﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/ListMalwareScansFilterCriterion.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Represents the criteria used to filter the malware scan
 * entries.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMalwareScansFilterCriteria">AWS
 * API Reference</a></p>
 */
class ListMalwareScansFilterCriteria {
 public:
  AWS_GUARDDUTY_API ListMalwareScansFilterCriteria() = default;
  AWS_GUARDDUTY_API ListMalwareScansFilterCriteria(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API ListMalwareScansFilterCriteria& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Represents a condition that when matched will be added to the response of the
   * operation.</p>
   */
  inline const Aws::Vector<ListMalwareScansFilterCriterion>& GetListMalwareScansFilterCriterion() const {
    return m_listMalwareScansFilterCriterion;
  }
  inline bool ListMalwareScansFilterCriterionHasBeenSet() const { return m_listMalwareScansFilterCriterionHasBeenSet; }
  template <typename ListMalwareScansFilterCriterionT = Aws::Vector<ListMalwareScansFilterCriterion>>
  void SetListMalwareScansFilterCriterion(ListMalwareScansFilterCriterionT&& value) {
    m_listMalwareScansFilterCriterionHasBeenSet = true;
    m_listMalwareScansFilterCriterion = std::forward<ListMalwareScansFilterCriterionT>(value);
  }
  template <typename ListMalwareScansFilterCriterionT = Aws::Vector<ListMalwareScansFilterCriterion>>
  ListMalwareScansFilterCriteria& WithListMalwareScansFilterCriterion(ListMalwareScansFilterCriterionT&& value) {
    SetListMalwareScansFilterCriterion(std::forward<ListMalwareScansFilterCriterionT>(value));
    return *this;
  }
  template <typename ListMalwareScansFilterCriterionT = ListMalwareScansFilterCriterion>
  ListMalwareScansFilterCriteria& AddListMalwareScansFilterCriterion(ListMalwareScansFilterCriterionT&& value) {
    m_listMalwareScansFilterCriterionHasBeenSet = true;
    m_listMalwareScansFilterCriterion.emplace_back(std::forward<ListMalwareScansFilterCriterionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ListMalwareScansFilterCriterion> m_listMalwareScansFilterCriterion;
  bool m_listMalwareScansFilterCriterionHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
