/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.componentpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.AbstractComponentPainter;
import net.infonode.util.Direction;

public class RectangleComponentPainter
extends AbstractComponentPainter {
    private static final long serialVersionUID = 1L;
    private final ColorProvider color;
    private final ColorProvider xorColor;
    private final Insets insets;

    public RectangleComponentPainter(Color color, int lineWidth) {
        this(new FixedColorProvider(color), lineWidth);
    }

    public RectangleComponentPainter(Color color, Color xorColor, int lineWidth) {
        this((ColorProvider)new FixedColorProvider(color), (ColorProvider)new FixedColorProvider(xorColor), lineWidth);
    }

    public RectangleComponentPainter(ColorProvider color, int lineWidth) {
        this(color, null, lineWidth);
    }

    public RectangleComponentPainter(ColorProvider color, ColorProvider xorColor, int lineWidth) {
        this(color, xorColor, new Insets(lineWidth, lineWidth, lineWidth, lineWidth));
    }

    public RectangleComponentPainter(ColorProvider color, ColorProvider xorColor, Insets insets) {
        this.color = color;
        this.xorColor = xorColor;
        this.insets = (Insets)insets.clone();
    }

    @Override
    public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
        Color xc = null;
        g.setColor(this.color.getColor(component));
        if (this.xorColor != null && (xc = this.xorColor.getColor(component)) != null) {
            g.setXORMode(xc);
        }
        Insets i = InsetsUtil.rotate(direction, new Insets(verticalFlip ? this.insets.bottom : this.insets.top, horizontalFlip ? this.insets.right : this.insets.left, verticalFlip ? this.insets.top : this.insets.bottom, horizontalFlip ? this.insets.left : this.insets.right));
        g.fillRect(x + i.left, y, width - i.left - i.right, i.top);
        g.fillRect(x + i.left, y + height - i.bottom, width - i.left - i.right, i.bottom);
        g.fillRect(x, y, i.left, height);
        g.fillRect(x + width - i.right, y, i.right, height);
        if (xc != null) {
            g.setPaintMode();
        }
    }

    @Override
    public boolean isOpaque(Component component) {
        return false;
    }

    @Override
    public Color getColor(Component component) {
        return this.color.getColor(component);
    }
}

