/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.x11;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.UnsafeUtil;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import jogamp.nativewindow.jawt.JAWTUtil;

public class X11SunJDKReflection {
    private static Class<?> x11GraphicsDeviceClass;
    private static Method x11GraphicsDeviceGetDisplayMethod;
    private static Class<?> x11GraphicsConfigClass;
    private static Method x11GraphicsConfigGetVisualMethod;
    private static boolean initialized;

    public static long graphicsDeviceGetDisplay(GraphicsDevice graphicsDevice) {
        if (!initialized) {
            return 0L;
        }
        try {
            return (Long)x11GraphicsDeviceGetDisplayMethod.invoke((Object)graphicsDevice, new Object[0]);
        }
        catch (Exception exception) {
            if (JAWTUtil.DEBUG) {
                ExceptionUtils.dumpThrowable((String)"X11SunJDKReflection", (Throwable)exception);
            }
            return 0L;
        }
    }

    public static int graphicsConfigurationGetVisualID(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        try {
            if (abstractGraphicsConfiguration instanceof AWTGraphicsConfiguration) {
                return X11SunJDKReflection.graphicsConfigurationGetVisualID(((AWTGraphicsConfiguration)abstractGraphicsConfiguration).getAWTGraphicsConfiguration());
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int graphicsConfigurationGetVisualID(GraphicsConfiguration graphicsConfiguration) {
        if (!initialized) {
            return 0;
        }
        try {
            return (Integer)x11GraphicsConfigGetVisualMethod.invoke((Object)graphicsConfiguration, new Object[0]);
        }
        catch (Exception exception) {
            if (JAWTUtil.DEBUG) {
                ExceptionUtils.dumpThrowable((String)"X11SunJDKReflection", (Throwable)exception);
            }
            return 0;
        }
    }

    static {
        SecurityUtil.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return UnsafeUtil.doWithoutIllegalAccessLogger((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        block2: {
                            try {
                                x11GraphicsDeviceClass = Class.forName("sun.awt.X11GraphicsDevice");
                                x11GraphicsDeviceGetDisplayMethod = x11GraphicsDeviceClass.getDeclaredMethod("getDisplay", new Class[0]);
                                x11GraphicsDeviceGetDisplayMethod.setAccessible(true);
                                x11GraphicsConfigClass = Class.forName("sun.awt.X11GraphicsConfig");
                                x11GraphicsConfigGetVisualMethod = x11GraphicsConfigClass.getDeclaredMethod("getVisual", new Class[0]);
                                x11GraphicsConfigGetVisualMethod.setAccessible(true);
                                initialized = true;
                            }
                            catch (Exception exception) {
                                if (!JAWTUtil.DEBUG) break block2;
                                ExceptionUtils.dumpThrowable((String)"X11SunJDKReflection", (Throwable)exception);
                            }
                        }
                        return null;
                    }
                });
            }
        });
    }
}

