/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayContainsUnnestFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayContainsOperatorFunction
extends ArrayContainsUnnestFunction {
    public ArrayContainsOperatorFunction(boolean nullable, TypeConfiguration typeConfiguration) {
        super(nullable, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        JdbcMapping needleType;
        Expression haystackExpression = (Expression)sqlAstArguments.get(0);
        Expression needleExpression = (Expression)sqlAstArguments.get(1);
        JdbcMappingContainer needleTypeContainer = needleExpression.getExpressionType();
        JdbcMapping jdbcMapping = needleType = needleTypeContainer == null ? null : needleTypeContainer.getSingleJdbcMapping();
        if (needleType == null || needleType instanceof BasicPluralType) {
            LOG.deprecatedArrayContainsWithArray();
            if (this.nullable) {
                super.render(sqlAppender, sqlAstArguments, returnType, walker);
            } else {
                haystackExpression.accept(walker);
                sqlAppender.append("@>");
                needleExpression.accept(walker);
            }
        } else if (this.nullable) {
            sqlAppender.append("array_position(");
            haystackExpression.accept(walker);
            sqlAppender.append(',');
            needleExpression.accept(walker);
            sqlAppender.append(") is not null");
        } else {
            haystackExpression.accept(walker);
            sqlAppender.append("@>");
            if (ArrayContainsOperatorFunction.needsArrayCasting(needleExpression)) {
                sqlAppender.append("cast(array[");
                needleExpression.accept(walker);
                sqlAppender.append("] as ");
                sqlAppender.append(DdlTypeHelper.getCastTypeName(haystackExpression.getExpressionType(), walker.getSessionFactory().getTypeConfiguration()));
                sqlAppender.append(')');
            } else {
                sqlAppender.append("array[");
                needleExpression.accept(walker);
                sqlAppender.append(']');
            }
        }
    }

    private static boolean needsArrayCasting(Expression elementExpression) {
        return elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString();
    }
}

