/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.ExtensionAlert;

class AlertTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private static final Comparator<AlertNode> GROUP_ALERT_CHILD_COMPARATOR = new GroupAlertChildNodeComparator();
    private static final Comparator<AlertNode> ALERT_CHILD_COMPARATOR = new AlertChildNodeComparator();
    private static final Logger LOGGER = LogManager.getLogger(AlertTreeModel.class);
    private ExtensionAlert ext;

    AlertTreeModel(ExtensionAlert ext) {
        super(new AlertNode(-1, Constant.messages.getString("alerts.tree.title"), GROUP_ALERT_CHILD_COMPARATOR));
        this.ext = ext;
    }

    void addPath(final Alert alert) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.addPathEventHandler(alert);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlertTreeModel.this.addPathEventHandler(alert);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public AlertNode getRoot() {
        return (AlertNode)super.getRoot();
    }

    protected synchronized AlertNode addPathEventHandler(Alert alert) {
        AlertNode parent = this.findAndAddGroup(this.getRoot(), alert.getName(), alert);
        Object method = "";
        if (alert.getMethod() != null) {
            method = alert.getMethod() + ":";
        }
        String name = (String)method + (StringUtils.isNotEmpty((CharSequence)alert.getNodeName()) ? alert.getNodeName() : alert.getUri());
        return this.addLeaf(parent, name, alert);
    }

    private AlertNode findLeafNodeForAlert(AlertNode parent, Alert alert) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AlertNode child = parent.getChildAt(i);
            if (child.getChildCount() == 0) {
                if (child.getAlert() == null || child.getAlert().compareTo(alert) != 0) continue;
                return child;
            }
            AlertNode node = this.findLeafNodeForAlert(child, alert);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public AlertNode getAlertNode(Alert alert) {
        AlertNode parent = this.getRoot();
        int risk = alert.getRisk();
        if (alert.getConfidence() == 0) {
            risk = -1;
        }
        AlertNode needle = new AlertNode(risk, alert.getName(), GROUP_ALERT_CHILD_COMPARATOR);
        needle.setAlert(alert);
        int idx = parent.findIndex(needle);
        if (idx < 0) {
            return null;
        }
        if ((idx = (parent = parent.getChildAt(idx)).findIndex(needle)) < 0) {
            return null;
        }
        return parent.getChildAt(idx);
    }

    void updatePath(final Alert alert) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.updatePathEventHandler(alert);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlertTreeModel.this.updatePathEventHandler(alert);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void updatePathEventHandler(Alert alert) {
        AlertNode node = this.findLeafNodeForAlert(this.getRoot(), alert);
        if (node != null) {
            AlertNode parent = node.getParent();
            this.removeChildById(parent, alert.getAlertId());
            this.nodeStructureChanged(parent);
            if (parent.getChildCount() == 0) {
                this.removeNodeFromParent(parent);
                this.nodeStructureChanged(this.getRoot());
            }
        }
        this.addPath(alert);
    }

    private void removeChildById(AlertNode parent, int alertId) {
        int idx = -1;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChildAt(i).getAlert().getAlertId() != alertId) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            parent.remove(idx);
        }
    }

    private AlertNode findAndAddGroup(AlertNode parent, String nodeName, Alert alert) {
        AlertNode node;
        int idx;
        int risk = alert.getRisk();
        if (alert.getConfidence() == 0) {
            risk = -1;
        }
        if ((idx = parent.findIndex(node = new AlertNode(risk, nodeName, ALERT_CHILD_COMPARATOR))) < 0) {
            idx = -(idx + 1);
            node.setAlert(alert);
            parent.insert(node, idx);
            this.nodesWereInserted(parent, new int[]{idx});
            this.nodeChanged(parent);
            return node;
        }
        return parent.getChildAt(idx);
    }

    private AlertNode addLeaf(AlertNode parent, String nodeName, Alert alert) {
        int risk = alert.getRisk();
        if (alert.getConfidence() == 0) {
            risk = -1;
        }
        AlertNode needle = new AlertNode(risk, nodeName, ALERT_CHILD_COMPARATOR);
        needle.setAlert(alert);
        int idx = parent.findIndex(needle);
        if (idx < 0) {
            if (this.ext.isOverSystemicLimit(alert)) {
                if (!parent.isSystemic()) {
                    parent.setSystemic(true);
                    this.nodeChanged(parent);
                }
                return null;
            }
            idx = -(idx + 1);
            parent.insert(needle, idx);
            this.nodesWereInserted(parent, new int[]{idx});
            this.nodeChanged(parent);
            return needle;
        }
        return null;
    }

    public synchronized void deletePath(Alert alert) {
        AlertNode node = this.findLeafNodeForAlert(this.getRoot(), alert);
        if (node != null) {
            AlertNode parent = node.getParent();
            if (parent.getChildCount() == 1) {
                parent.remove(0);
                AlertNode grandParent = parent.getParent();
                this.removeNodeFromParent(parent);
                this.nodeChanged(grandParent);
                return;
            }
            this.removeNodeFromParent(node);
            if (parent.getAlert() == node.getAlert()) {
                parent.setAlert(parent.getChildAt(0).getAlert());
            }
            this.nodeChanged(parent);
        }
    }

    private static class GroupAlertChildNodeComparator
    implements Comparator<AlertNode> {
        private GroupAlertChildNodeComparator() {
        }

        @Override
        public int compare(AlertNode alertNode, AlertNode anotherAlertNode) {
            if (alertNode.getRisk() < anotherAlertNode.getRisk()) {
                return 1;
            }
            if (alertNode.getRisk() > anotherAlertNode.getRisk()) {
                return -1;
            }
            return alertNode.getNodeName().compareTo(anotherAlertNode.getNodeName());
        }
    }

    private static class AlertChildNodeComparator
    implements Comparator<AlertNode> {
        private AlertChildNodeComparator() {
        }

        @Override
        public int compare(AlertNode alertNode, AlertNode anotherAlertNode) {
            return alertNode.getAlert().compareTo(anotherAlertNode.getAlert());
        }
    }
}

