# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AzureMonitorWorkspaceIntegration(_Model):
    """Integrations for Azure Monitor Workspace.

    :ivar azure_monitor_workspace_resource_id: The resource Id of the connected Azure Monitor
     Workspace.
    :vartype azure_monitor_workspace_resource_id: str
    """

    azure_monitor_workspace_resource_id: Optional[str] = rest_field(
        name="azureMonitorWorkspaceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource Id of the connected Azure Monitor Workspace."""

    @overload
    def __init__(
        self,
        *,
        azure_monitor_workspace_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnterpriseConfigurations(_Model):
    """Enterprise settings of a Grafana instance.

    :ivar marketplace_plan_id: The Plan Id of the Azure Marketplace subscription for the Enterprise
     plugins.
    :vartype marketplace_plan_id: str
    :ivar marketplace_auto_renew: The AutoRenew setting of the Enterprise subscription. Known
     values are: "Disabled" and "Enabled".
    :vartype marketplace_auto_renew: str or ~azure.mgmt.dashboard.models.MarketplaceAutoRenew
    """

    marketplace_plan_id: Optional[str] = rest_field(
        name="marketplacePlanId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Plan Id of the Azure Marketplace subscription for the Enterprise plugins."""
    marketplace_auto_renew: Optional[Union[str, "_models.MarketplaceAutoRenew"]] = rest_field(
        name="marketplaceAutoRenew", visibility=["read", "create", "update", "delete", "query"]
    )
    """The AutoRenew setting of the Enterprise subscription. Known values are: \"Disabled\" and
     \"Enabled\"."""

    @overload
    def __init__(
        self,
        *,
        marketplace_plan_id: Optional[str] = None,
        marketplace_auto_renew: Optional[Union[str, "_models.MarketplaceAutoRenew"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnterpriseDetails(_Model):
    """Enterprise details of a Grafana instance.

    :ivar saas_subscription_details: SaaS subscription details of a Grafana instance.
    :vartype saas_subscription_details: ~azure.mgmt.dashboard.models.SaasSubscriptionDetails
    :ivar marketplace_trial_quota: The allocation details of the per subscription free trial slot
     of the subscription.
    :vartype marketplace_trial_quota: ~azure.mgmt.dashboard.models.MarketplaceTrialQuota
    """

    saas_subscription_details: Optional["_models.SaasSubscriptionDetails"] = rest_field(
        name="saasSubscriptionDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """SaaS subscription details of a Grafana instance."""
    marketplace_trial_quota: Optional["_models.MarketplaceTrialQuota"] = rest_field(
        name="marketplaceTrialQuota", visibility=["read", "create", "update", "delete", "query"]
    )
    """The allocation details of the per subscription free trial slot of the subscription."""

    @overload
    def __init__(
        self,
        *,
        saas_subscription_details: Optional["_models.SaasSubscriptionDetails"] = None,
        marketplace_trial_quota: Optional["_models.MarketplaceTrialQuota"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dashboard.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dashboard.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.dashboard.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GrafanaAvailablePlugin(_Model):
    """Available plugins of grafana.

    :ivar plugin_id: Grafana plugin id.
    :vartype plugin_id: str
    :ivar name: Grafana plugin display name.
    :vartype name: str
    :ivar type: Grafana plugin type.
    :vartype type: str
    :ivar author: Grafana plugin author/publisher name.
    :vartype author: str
    """

    plugin_id: Optional[str] = rest_field(name="pluginId", visibility=["read"])
    """Grafana plugin id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Grafana plugin display name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """Grafana plugin type."""
    author: Optional[str] = rest_field(visibility=["read"])
    """Grafana plugin author/publisher name."""


class GrafanaAvailablePluginListResponse(_Model):
    """GrafanaAvailablePluginListResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.dashboard.models.GrafanaAvailablePlugin]
    :ivar next_link:
    :vartype next_link: str
    """

    value: Optional[list["_models.GrafanaAvailablePlugin"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        value: Optional[list["_models.GrafanaAvailablePlugin"]] = None,
        next_link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GrafanaConfigurations(_Model):
    """Server configurations of a Grafana instance.

       :ivar smtp: Email server settings.
    `https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp
        <https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp>`_.
       :vartype smtp: ~azure.mgmt.dashboard.models.Smtp
       :ivar snapshots: Grafana Snapshots settings.
       :vartype snapshots: ~azure.mgmt.dashboard.models.Snapshots
       :ivar users: Grafana users settings.
       :vartype users: ~azure.mgmt.dashboard.models.Users
       :ivar security: Grafana security settings.
       :vartype security: ~azure.mgmt.dashboard.models.Security
       :ivar unified_alerting_screenshots: Grafana Unified Alerting Screenshots settings.
       :vartype unified_alerting_screenshots: ~azure.mgmt.dashboard.models.UnifiedAlertingScreenshots
    """

    smtp: Optional["_models.Smtp"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Email server settings.
 `https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp
     <https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp>`_."""
    snapshots: Optional["_models.Snapshots"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Grafana Snapshots settings."""
    users: Optional["_models.Users"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Grafana users settings."""
    security: Optional["_models.Security"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Grafana security settings."""
    unified_alerting_screenshots: Optional["_models.UnifiedAlertingScreenshots"] = rest_field(
        name="unifiedAlertingScreenshots", visibility=["read", "create", "update", "delete", "query"]
    )
    """Grafana Unified Alerting Screenshots settings."""

    @overload
    def __init__(
        self,
        *,
        smtp: Optional["_models.Smtp"] = None,
        snapshots: Optional["_models.Snapshots"] = None,
        users: Optional["_models.Users"] = None,
        security: Optional["_models.Security"] = None,
        unified_alerting_screenshots: Optional["_models.UnifiedAlertingScreenshots"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GrafanaIntegrations(_Model):
    """GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source,
    tailored Grafana dashboards, alerting defaults) for common monitoring scenarios.

    :ivar azure_monitor_workspace_integrations:
    :vartype azure_monitor_workspace_integrations:
     list[~azure.mgmt.dashboard.models.AzureMonitorWorkspaceIntegration]
    """

    azure_monitor_workspace_integrations: Optional[list["_models.AzureMonitorWorkspaceIntegration"]] = rest_field(
        name="azureMonitorWorkspaceIntegrations", visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        azure_monitor_workspace_integrations: Optional[list["_models.AzureMonitorWorkspaceIntegration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GrafanaPlugin(_Model):
    """Plugin of Grafana.

    :ivar plugin_id: Grafana plugin id.
    :vartype plugin_id: str
    """

    plugin_id: Optional[str] = rest_field(name="pluginId", visibility=["read"])
    """Grafana plugin id."""


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IntegrationFabric(TrackedResource):
    """The integration fabric resource type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.dashboard.models.IntegrationFabricProperties
    """

    properties: Optional["_models.IntegrationFabricProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.IntegrationFabricProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IntegrationFabricProperties(_Model):
    """IntegrationFabricProperties.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    :ivar target_resource_id: The resource Id of the Azure resource being integrated with Azure
     Managed Grafana. E.g., an Azure Kubernetes Service cluster.
    :vartype target_resource_id: str
    :ivar data_source_resource_id: The resource Id of the Azure resource which is used to configure
     Grafana data source. E.g., an Azure Monitor Workspace, an Azure Data Explorer cluster, etc.
    :vartype data_source_resource_id: str
    :ivar scenarios: A list of integration scenarios covered by this integration fabric.
    :vartype scenarios: list[str]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Accepted\", \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleted\", and \"NotSpecified\"."""
    target_resource_id: Optional[str] = rest_field(
        name="targetResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource Id of the Azure resource being integrated with Azure Managed Grafana. E.g., an
     Azure Kubernetes Service cluster."""
    data_source_resource_id: Optional[str] = rest_field(
        name="dataSourceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource Id of the Azure resource which is used to configure Grafana data source. E.g., an
     Azure Monitor Workspace, an Azure Data Explorer cluster, etc."""
    scenarios: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of integration scenarios covered by this integration fabric."""

    @overload
    def __init__(
        self,
        *,
        target_resource_id: Optional[str] = None,
        data_source_resource_id: Optional[str] = None,
        scenarios: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IntegrationFabricPropertiesUpdateParameters(_Model):  # pylint: disable=name-too-long
    """IntegrationFabricPropertiesUpdateParameters.

    :ivar scenarios: The new integration scenarios covered by this integration fabric.
    :vartype scenarios: list[str]
    """

    scenarios: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The new integration scenarios covered by this integration fabric."""

    @overload
    def __init__(
        self,
        *,
        scenarios: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IntegrationFabricUpdateParameters(_Model):
    """The parameters for a PATCH request to a Integration Fabric resource.

    :ivar tags: The new tags of the Integration Fabric resource.
    :vartype tags: dict[str, str]
    :ivar properties: The new properties of this Integration Fabric resource.
    :vartype properties: ~azure.mgmt.dashboard.models.IntegrationFabricPropertiesUpdateParameters
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The new tags of the Integration Fabric resource."""
    properties: Optional["_models.IntegrationFabricPropertiesUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The new properties of this Integration Fabric resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.IntegrationFabricPropertiesUpdateParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedDashboard(TrackedResource):
    """The managed dashboard resource type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties specific to the managed dashboard resource.
    :vartype properties: ~azure.mgmt.dashboard.models.ManagedDashboardProperties
    """

    properties: Optional["_models.ManagedDashboardProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties specific to the managed dashboard resource."""

    __flattened_items = ["provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ManagedDashboardProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ManagedDashboardProperties(_Model):
    """Properties specific to the grafana resource.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Accepted\", \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleted\", and \"NotSpecified\"."""


class ManagedDashboardUpdateParameters(_Model):
    """The parameters for a PATCH request to a managed dashboard resource.

    :ivar tags: The new tags of the managed dashboard resource.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The new tags of the managed dashboard resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    """


class ManagedGrafana(ProxyResource):
    """The grafana resource type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar properties: Properties specific to the grafana resource.
    :vartype properties: ~azure.mgmt.dashboard.models.ManagedGrafanaProperties
    :ivar sku: The Sku of the grafana resource.
    :vartype sku: ~azure.mgmt.dashboard.models.ResourceSku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.dashboard.models.ManagedServiceIdentity
    """

    properties: Optional["_models.ManagedGrafanaProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties specific to the grafana resource."""
    sku: Optional["_models.ResourceSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Sku of the grafana resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ManagedGrafanaProperties"] = None,
        sku: Optional["_models.ResourceSku"] = None,
        tags: Optional[dict[str, str]] = None,
        location: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedGrafanaProperties(_Model):
    """Properties specific to the grafana resource.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    :ivar grafana_version: The Grafana software version.
    :vartype grafana_version: str
    :ivar endpoint: The endpoint of the Grafana instance.
    :vartype endpoint: str
    :ivar public_network_access: Indicate the state for enable or disable traffic over the public
     interface. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.dashboard.models.PublicNetworkAccess
    :ivar zone_redundancy: The zone redundancy setting of the Grafana instance. Known values are:
     "Disabled" and "Enabled".
    :vartype zone_redundancy: str or ~azure.mgmt.dashboard.models.ZoneRedundancy
    :ivar api_key: The api key setting of the Grafana instance. Known values are: "Disabled" and
     "Enabled".
    :vartype api_key: str or ~azure.mgmt.dashboard.models.ApiKey
    :ivar creator_can_admin: The creator will have admin access for the Grafana instance. Known
     values are: "Disabled" and "Enabled".
    :vartype creator_can_admin: str or ~azure.mgmt.dashboard.models.CreatorCanAdmin
    :ivar deterministic_outbound_ip: Whether a Grafana instance uses deterministic outbound IPs.
     Known values are: "Disabled" and "Enabled".
    :vartype deterministic_outbound_ip: str or ~azure.mgmt.dashboard.models.DeterministicOutboundIP
    :ivar outbound_i_ps: List of outbound IPs if deterministicOutboundIP is enabled.
    :vartype outbound_i_ps: list[str]
    :ivar private_endpoint_connections: The private endpoint connections of the Grafana instance.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.dashboard.models.PrivateEndpointConnection]
    :ivar auto_generated_domain_name_label_scope: Scope for dns deterministic name hash
     calculation. "TenantReuse"
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.dashboard.models.AutoGeneratedDomainNameLabelScope
    :ivar grafana_integrations: GrafanaIntegrations is a bundled observability experience (e.g.
     pre-configured data source, tailored Grafana dashboards, alerting defaults) for common
     monitoring scenarios.
    :vartype grafana_integrations: ~azure.mgmt.dashboard.models.GrafanaIntegrations
    :ivar enterprise_configurations: Enterprise settings of a Grafana instance.
    :vartype enterprise_configurations: ~azure.mgmt.dashboard.models.EnterpriseConfigurations
    :ivar grafana_configurations: Server configurations of a Grafana instance.
    :vartype grafana_configurations: ~azure.mgmt.dashboard.models.GrafanaConfigurations
    :ivar grafana_plugins: Installed plugin list of the Grafana instance. Key is plugin id, value
     is plugin definition.
    :vartype grafana_plugins: dict[str, ~azure.mgmt.dashboard.models.GrafanaPlugin]
    :ivar grafana_major_version: The major Grafana software version to target.
    :vartype grafana_major_version: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Accepted\", \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleted\", and \"NotSpecified\"."""
    grafana_version: Optional[str] = rest_field(name="grafanaVersion", visibility=["read"])
    """The Grafana software version."""
    endpoint: Optional[str] = rest_field(visibility=["read"])
    """The endpoint of the Grafana instance."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicate the state for enable or disable traffic over the public interface. Known values are:
     \"Enabled\" and \"Disabled\"."""
    zone_redundancy: Optional[Union[str, "_models.ZoneRedundancy"]] = rest_field(
        name="zoneRedundancy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The zone redundancy setting of the Grafana instance. Known values are: \"Disabled\" and
     \"Enabled\"."""
    api_key: Optional[Union[str, "_models.ApiKey"]] = rest_field(
        name="apiKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The api key setting of the Grafana instance. Known values are: \"Disabled\" and \"Enabled\"."""
    creator_can_admin: Optional[Union[str, "_models.CreatorCanAdmin"]] = rest_field(
        name="creatorCanAdmin", visibility=["read", "create", "update", "delete", "query"]
    )
    """The creator will have admin access for the Grafana instance. Known values are: \"Disabled\" and
     \"Enabled\"."""
    deterministic_outbound_ip: Optional[Union[str, "_models.DeterministicOutboundIP"]] = rest_field(
        name="deterministicOutboundIP", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether a Grafana instance uses deterministic outbound IPs. Known values are: \"Disabled\" and
     \"Enabled\"."""
    outbound_i_ps: Optional[list[str]] = rest_field(name="outboundIPs", visibility=["read"])
    """List of outbound IPs if deterministicOutboundIP is enabled."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """The private endpoint connections of the Grafana instance."""
    auto_generated_domain_name_label_scope: Optional[Union[str, "_models.AutoGeneratedDomainNameLabelScope"]] = (
        rest_field(name="autoGeneratedDomainNameLabelScope", visibility=["read", "create"])
    )
    """Scope for dns deterministic name hash calculation. \"TenantReuse\""""
    grafana_integrations: Optional["_models.GrafanaIntegrations"] = rest_field(
        name="grafanaIntegrations", visibility=["read", "create", "update", "delete", "query"]
    )
    """GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source,
     tailored Grafana dashboards, alerting defaults) for common monitoring scenarios."""
    enterprise_configurations: Optional["_models.EnterpriseConfigurations"] = rest_field(
        name="enterpriseConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enterprise settings of a Grafana instance."""
    grafana_configurations: Optional["_models.GrafanaConfigurations"] = rest_field(
        name="grafanaConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Server configurations of a Grafana instance."""
    grafana_plugins: Optional[dict[str, "_models.GrafanaPlugin"]] = rest_field(
        name="grafanaPlugins", visibility=["read", "create", "update", "delete", "query"]
    )
    """Installed plugin list of the Grafana instance. Key is plugin id, value is plugin definition."""
    grafana_major_version: Optional[str] = rest_field(
        name="grafanaMajorVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The major Grafana software version to target."""

    @overload
    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        zone_redundancy: Optional[Union[str, "_models.ZoneRedundancy"]] = None,
        api_key: Optional[Union[str, "_models.ApiKey"]] = None,
        creator_can_admin: Optional[Union[str, "_models.CreatorCanAdmin"]] = None,
        deterministic_outbound_ip: Optional[Union[str, "_models.DeterministicOutboundIP"]] = None,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        grafana_integrations: Optional["_models.GrafanaIntegrations"] = None,
        enterprise_configurations: Optional["_models.EnterpriseConfigurations"] = None,
        grafana_configurations: Optional["_models.GrafanaConfigurations"] = None,
        grafana_plugins: Optional[dict[str, "_models.GrafanaPlugin"]] = None,
        grafana_major_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedGrafanaPropertiesUpdateParameters(_Model):
    """The properties parameters for a PATCH request to a grafana resource.

    :ivar zone_redundancy: The zone redundancy setting of the Grafana instance. Known values are:
     "Disabled" and "Enabled".
    :vartype zone_redundancy: str or ~azure.mgmt.dashboard.models.ZoneRedundancy
    :ivar api_key: The api key setting of the Grafana instance. Known values are: "Disabled" and
     "Enabled".
    :vartype api_key: str or ~azure.mgmt.dashboard.models.ApiKey
    :ivar creator_can_admin: The creator will have admin access for the Grafana instance. Known
     values are: "Disabled" and "Enabled".
    :vartype creator_can_admin: str or ~azure.mgmt.dashboard.models.CreatorCanAdmin
    :ivar deterministic_outbound_ip: Whether a Grafana instance uses deterministic outbound IPs.
     Known values are: "Disabled" and "Enabled".
    :vartype deterministic_outbound_ip: str or ~azure.mgmt.dashboard.models.DeterministicOutboundIP
    :ivar public_network_access: Indicate the state for enable or disable traffic over the public
     interface. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.dashboard.models.PublicNetworkAccess
    :ivar grafana_integrations: GrafanaIntegrations is a bundled observability experience (e.g.
     pre-configured data source, tailored Grafana dashboards, alerting defaults) for common
     monitoring scenarios.
    :vartype grafana_integrations: ~azure.mgmt.dashboard.models.GrafanaIntegrations
    :ivar enterprise_configurations: Enterprise settings of a Grafana instance.
    :vartype enterprise_configurations: ~azure.mgmt.dashboard.models.EnterpriseConfigurations
    :ivar grafana_configurations: Server configurations of a Grafana instance.
    :vartype grafana_configurations: ~azure.mgmt.dashboard.models.GrafanaConfigurations
    :ivar grafana_plugins: Update of Grafana plugin. Key is plugin id, value is plugin definition.
     If plugin definition is null, plugin with given plugin id will be removed. Otherwise, given
     plugin will be installed.
    :vartype grafana_plugins: dict[str, ~azure.mgmt.dashboard.models.GrafanaPlugin]
    :ivar grafana_major_version: The major Grafana software version to target.
    :vartype grafana_major_version: str
    """

    zone_redundancy: Optional[Union[str, "_models.ZoneRedundancy"]] = rest_field(
        name="zoneRedundancy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The zone redundancy setting of the Grafana instance. Known values are: \"Disabled\" and
     \"Enabled\"."""
    api_key: Optional[Union[str, "_models.ApiKey"]] = rest_field(
        name="apiKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The api key setting of the Grafana instance. Known values are: \"Disabled\" and \"Enabled\"."""
    creator_can_admin: Optional[Union[str, "_models.CreatorCanAdmin"]] = rest_field(
        name="creatorCanAdmin", visibility=["read", "create", "update", "delete", "query"]
    )
    """The creator will have admin access for the Grafana instance. Known values are: \"Disabled\" and
     \"Enabled\"."""
    deterministic_outbound_ip: Optional[Union[str, "_models.DeterministicOutboundIP"]] = rest_field(
        name="deterministicOutboundIP", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether a Grafana instance uses deterministic outbound IPs. Known values are: \"Disabled\" and
     \"Enabled\"."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicate the state for enable or disable traffic over the public interface. Known values are:
     \"Enabled\" and \"Disabled\"."""
    grafana_integrations: Optional["_models.GrafanaIntegrations"] = rest_field(
        name="grafanaIntegrations", visibility=["read", "create", "update", "delete", "query"]
    )
    """GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source,
     tailored Grafana dashboards, alerting defaults) for common monitoring scenarios."""
    enterprise_configurations: Optional["_models.EnterpriseConfigurations"] = rest_field(
        name="enterpriseConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enterprise settings of a Grafana instance."""
    grafana_configurations: Optional["_models.GrafanaConfigurations"] = rest_field(
        name="grafanaConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Server configurations of a Grafana instance."""
    grafana_plugins: Optional[dict[str, "_models.GrafanaPlugin"]] = rest_field(
        name="grafanaPlugins", visibility=["read", "create", "update", "delete", "query"]
    )
    """Update of Grafana plugin. Key is plugin id, value is plugin definition. If plugin definition is
     null, plugin with given plugin id will be removed. Otherwise, given plugin will be installed."""
    grafana_major_version: Optional[str] = rest_field(
        name="grafanaMajorVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The major Grafana software version to target."""

    @overload
    def __init__(
        self,
        *,
        zone_redundancy: Optional[Union[str, "_models.ZoneRedundancy"]] = None,
        api_key: Optional[Union[str, "_models.ApiKey"]] = None,
        creator_can_admin: Optional[Union[str, "_models.CreatorCanAdmin"]] = None,
        deterministic_outbound_ip: Optional[Union[str, "_models.DeterministicOutboundIP"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        grafana_integrations: Optional["_models.GrafanaIntegrations"] = None,
        enterprise_configurations: Optional["_models.EnterpriseConfigurations"] = None,
        grafana_configurations: Optional["_models.GrafanaConfigurations"] = None,
        grafana_plugins: Optional[dict[str, "_models.GrafanaPlugin"]] = None,
        grafana_major_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedGrafanaUpdateParameters(_Model):
    """The parameters for a PATCH request to a grafana resource.

    :ivar sku:
    :vartype sku: ~azure.mgmt.dashboard.models.ResourceSku
    :ivar identity: The managed identity of the grafana resource.
    :vartype identity: ~azure.mgmt.dashboard.models.ManagedServiceIdentity
    :ivar tags: The new tags of the grafana resource.
    :vartype tags: dict[str, str]
    :ivar properties: Properties specific to the managed grafana resource.
    :vartype properties: ~azure.mgmt.dashboard.models.ManagedGrafanaPropertiesUpdateParameters
    """

    sku: Optional["_models.ResourceSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed identity of the grafana resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The new tags of the grafana resource."""
    properties: Optional["_models.ManagedGrafanaPropertiesUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties specific to the managed grafana resource."""

    @overload
    def __init__(
        self,
        *,
        sku: Optional["_models.ResourceSku"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ManagedGrafanaPropertiesUpdateParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedPrivateEndpointConnectionState(_Model):
    """The state of managed private endpoint connection.

    :ivar status: The approval/rejection status of managed private endpoint connection. Known
     values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.dashboard.models.ManagedPrivateEndpointConnectionStatus
    :ivar description: Gets or sets the reason for approval/rejection of the connection.
    :vartype description: str
    """

    status: Optional[Union[str, "_models.ManagedPrivateEndpointConnectionStatus"]] = rest_field(visibility=["read"])
    """The approval/rejection status of managed private endpoint connection. Known values are:
     \"Pending\", \"Approved\", \"Rejected\", and \"Disconnected\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Gets or sets the reason for approval/rejection of the connection."""


class ManagedPrivateEndpointModel(TrackedResource):
    """The managed private endpoint resource type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.dashboard.models.ManagedPrivateEndpointModelProperties
    """

    properties: Optional["_models.ManagedPrivateEndpointModelProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    __flattened_items = [
        "provisioning_state",
        "private_link_resource_id",
        "private_link_resource_region",
        "group_ids",
        "request_message",
        "connection_state",
        "private_link_service_url",
        "private_link_service_private_ip",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ManagedPrivateEndpointModelProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ManagedPrivateEndpointModelProperties(_Model):
    """Properties specific to the managed private endpoint.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    :ivar private_link_resource_id: The ARM resource ID of the resource for which the managed
     private endpoint is pointing to.
    :vartype private_link_resource_id: str
    :ivar private_link_resource_region: The region of the resource to which the managed private
     endpoint is pointing to.
    :vartype private_link_resource_region: str
    :ivar group_ids: The group Ids of the managed private endpoint.
    :vartype group_ids: list[str]
    :ivar request_message: User input request message of the managed private endpoint.
    :vartype request_message: str
    :ivar connection_state: The state of managed private endpoint connection.
    :vartype connection_state: ~azure.mgmt.dashboard.models.ManagedPrivateEndpointConnectionState
    :ivar private_link_service_url: The URL of the data store behind the private link service. It
     would be the URL in the Grafana data source configuration page without the protocol and port.
    :vartype private_link_service_url: str
    :ivar private_link_service_private_ip: The private IP of private endpoint after approval. This
     property is empty before connection is approved.
    :vartype private_link_service_private_ip: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Accepted\", \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleted\", and \"NotSpecified\"."""
    private_link_resource_id: Optional[str] = rest_field(name="privateLinkResourceId", visibility=["read", "create"])
    """The ARM resource ID of the resource for which the managed private endpoint is pointing to."""
    private_link_resource_region: Optional[str] = rest_field(
        name="privateLinkResourceRegion", visibility=["read", "create"]
    )
    """The region of the resource to which the managed private endpoint is pointing to."""
    group_ids: Optional[list[str]] = rest_field(name="groupIds", visibility=["read", "create"])
    """The group Ids of the managed private endpoint."""
    request_message: Optional[str] = rest_field(name="requestMessage", visibility=["read", "create"])
    """User input request message of the managed private endpoint."""
    connection_state: Optional["_models.ManagedPrivateEndpointConnectionState"] = rest_field(
        name="connectionState", visibility=["read"]
    )
    """The state of managed private endpoint connection."""
    private_link_service_url: Optional[str] = rest_field(name="privateLinkServiceUrl", visibility=["read", "create"])
    """The URL of the data store behind the private link service. It would be the URL in the Grafana
     data source configuration page without the protocol and port."""
    private_link_service_private_ip: Optional[str] = rest_field(name="privateLinkServicePrivateIP", visibility=["read"])
    """The private IP of private endpoint after approval. This property is empty before connection is
     approved."""

    @overload
    def __init__(
        self,
        *,
        private_link_resource_id: Optional[str] = None,
        private_link_resource_region: Optional[str] = None,
        group_ids: Optional[list[str]] = None,
        request_message: Optional[str] = None,
        private_link_service_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedPrivateEndpointUpdateParameters(_Model):
    """The parameters for a PATCH request to a managed private endpoint.

    :ivar tags: The new tags of the managed private endpoint.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The new tags of the managed private endpoint."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.dashboard.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.dashboard.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceTrialQuota(_Model):
    """The allocation details of the per subscription free trial slot of the subscription.

    :ivar available_promotion: Available enterprise promotion for the subscription. Known values
     are: "None" and "FreeTrial".
    :vartype available_promotion: str or ~azure.mgmt.dashboard.models.AvailablePromotion
    :ivar grafana_resource_id: Resource Id of the Grafana resource which is doing the trial.
    :vartype grafana_resource_id: str
    :ivar trial_start_at: The date and time in UTC of when the trial starts.
    :vartype trial_start_at: ~datetime.datetime
    :ivar trial_end_at: The date and time in UTC of when the trial ends.
    :vartype trial_end_at: ~datetime.datetime
    """

    available_promotion: Optional[Union[str, "_models.AvailablePromotion"]] = rest_field(
        name="availablePromotion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Available enterprise promotion for the subscription. Known values are: \"None\" and
     \"FreeTrial\"."""
    grafana_resource_id: Optional[str] = rest_field(
        name="grafanaResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Id of the Grafana resource which is doing the trial."""
    trial_start_at: Optional[datetime.datetime] = rest_field(
        name="trialStartAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The date and time in UTC of when the trial starts."""
    trial_end_at: Optional[datetime.datetime] = rest_field(
        name="trialEndAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The date and time in UTC of when the trial ends."""

    @overload
    def __init__(
        self,
        *,
        available_promotion: Optional[Union[str, "_models.AvailablePromotion"]] = None,
        grafana_resource_id: Optional[str] = None,
        trial_start_at: Optional[datetime.datetime] = None,
        trial_end_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.dashboard.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.dashboard.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.dashboard.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PrivateEndpoint(_Model):
    """The private endpoint resource.

    :ivar id: The resource identifier of the private endpoint.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource identifier of the private endpoint."""


class PrivateEndpointConnection(ProxyResource):
    """The Private Endpoint Connection resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.dashboard.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    __flattened_items = ["private_endpoint", "private_link_service_connection_state", "group_ids", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateEndpointConnectionProperties(_Model):
    """Properties of the PrivateEndpointConnectProperties.

    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.dashboard.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.dashboard.models.PrivateLinkServiceConnectionState
    :ivar group_ids: The private endpoint connection group ids.
    :vartype group_ids: list[str]
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.dashboard.models.PrivateEndpointConnectionProvisioningState
    """

    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource of private end point."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """A collection of information about the state of the connection between service consumer and
     provider. Required."""
    group_ids: Optional[list[str]] = rest_field(
        name="groupIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private endpoint connection group ids."""
    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the private endpoint connection resource. Known values are:
     \"Succeeded\", \"Creating\", \"Deleting\", and \"Failed\"."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        group_ids: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.dashboard.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    __flattened_items = ["provisioning_state", "group_id", "required_members", "required_zone_names"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateLinkResourceProperties(_Model):
    """Properties of a private link resource.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Accepted\", \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleted\", and \"NotSpecified\"."""
    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The private link resource group id."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The private link resource required member names."""
    required_zone_names: Optional[list[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private link resource Private link DNS zone name."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.dashboard.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
     service. Known values are: \"Pending\", \"Approved\", and \"Rejected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reason for approval/rejection of the connection."""
    actions_required: Optional[str] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """A message indicating if changes on the service provider require any updates on the consumer."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceSku(_Model):
    """Represents the SKU of a resource.

    :ivar name: The name of the SKU. Required.
    :vartype name: str
    :ivar size: Specifies the capacity tier of the Grafana instance. Known values are: "X1" and
     "X2".
    :vartype size: str or ~azure.mgmt.dashboard.models.Size
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the SKU. Required."""
    size: Optional[Union[str, "_models.Size"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the capacity tier of the Grafana instance. Known values are: \"X1\" and \"X2\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        size: Optional[Union[str, "_models.Size"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SaasSubscriptionDetails(_Model):
    """SaaS subscription details of a Grafana instance.

    :ivar plan_id: The plan Id of the SaaS subscription.
    :vartype plan_id: str
    :ivar offer_id: The offer Id of the SaaS subscription.
    :vartype offer_id: str
    :ivar publisher_id: The publisher Id of the SaaS subscription.
    :vartype publisher_id: str
    :ivar term: The billing term of the SaaS Subscription.
    :vartype term: ~azure.mgmt.dashboard.models.SubscriptionTerm
    """

    plan_id: Optional[str] = rest_field(name="planId", visibility=["read", "create", "update", "delete", "query"])
    """The plan Id of the SaaS subscription."""
    offer_id: Optional[str] = rest_field(name="offerId", visibility=["read", "create", "update", "delete", "query"])
    """The offer Id of the SaaS subscription."""
    publisher_id: Optional[str] = rest_field(
        name="publisherId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The publisher Id of the SaaS subscription."""
    term: Optional["_models.SubscriptionTerm"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The billing term of the SaaS Subscription."""

    @overload
    def __init__(
        self,
        *,
        plan_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        publisher_id: Optional[str] = None,
        term: Optional["_models.SubscriptionTerm"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Security(_Model):
    """Grafana security settings.

    :ivar csrf_always_check: Set to true to execute the CSRF check even if the login cookie is not
     in a request (default false).
    :vartype csrf_always_check: bool
    """

    csrf_always_check: Optional[bool] = rest_field(
        name="csrfAlwaysCheck", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set to true to execute the CSRF check even if the login cookie is not in a request (default
     false)."""

    @overload
    def __init__(
        self,
        *,
        csrf_always_check: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Smtp(_Model):
    """Email server settings.
    `https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp
        <https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp>`_.

        :ivar enabled: Enable this to allow Grafana to send email. Default is false.
        :vartype enabled: bool
        :ivar host: SMTP server hostname with port, e.g. test.email.net:587.
        :vartype host: str
        :ivar user: User of SMTP auth.
        :vartype user: str
        :ivar password: Password of SMTP auth. If the password contains # or ;, then you have to wrap
         it with triple quotes.
        :vartype password: str
        :ivar from_address: Address used when sending out emails
     `https://pkg.go.dev/net/mail#Address <https://pkg.go.dev/net/mail#Address>`_.
        :vartype from_address: str
        :ivar from_name: Name to be used when sending out emails. Default is "Azure Managed Grafana
         Notification"
     `https://pkg.go.dev/net/mail#Address <https://pkg.go.dev/net/mail#Address>`_.
        :vartype from_name: str
        :ivar start_tls_policy: The StartTLSPolicy setting of the SMTP configuration
     `https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy
         <https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy>`_. Known values are:
         "OpportunisticStartTLS", "MandatoryStartTLS", and "NoStartTLS".
        :vartype start_tls_policy: str or ~azure.mgmt.dashboard.models.StartTLSPolicy
        :ivar skip_verify: Verify SSL for SMTP server. Default is false
     `https://pkg.go.dev/crypto/tls#Config <https://pkg.go.dev/crypto/tls#Config>`_.
        :vartype skip_verify: bool
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Enable this to allow Grafana to send email. Default is false."""
    host: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SMTP server hostname with port, e.g. test.email.net:587."""
    user: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User of SMTP auth."""
    password: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Password of SMTP auth. If the password contains # or ;, then you have to wrap it with triple
     quotes."""
    from_address: Optional[str] = rest_field(
        name="fromAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Address used when sending out emails
 `https://pkg.go.dev/net/mail#Address <https://pkg.go.dev/net/mail#Address>`_."""
    from_name: Optional[str] = rest_field(name="fromName", visibility=["read", "create", "update", "delete", "query"])
    """Name to be used when sending out emails. Default is \"Azure Managed Grafana Notification\"
 `https://pkg.go.dev/net/mail#Address <https://pkg.go.dev/net/mail#Address>`_."""
    start_tls_policy: Optional[Union[str, "_models.StartTLSPolicy"]] = rest_field(
        name="startTLSPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The StartTLSPolicy setting of the SMTP configuration
 `https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy
     <https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy>`_. Known values are:
     \"OpportunisticStartTLS\", \"MandatoryStartTLS\", and \"NoStartTLS\"."""
    skip_verify: Optional[bool] = rest_field(
        name="skipVerify", visibility=["read", "create", "update", "delete", "query"]
    )
    """Verify SSL for SMTP server. Default is false
 `https://pkg.go.dev/crypto/tls#Config <https://pkg.go.dev/crypto/tls#Config>`_."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        host: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        from_address: Optional[str] = None,
        from_name: Optional[str] = None,
        start_tls_policy: Optional[Union[str, "_models.StartTLSPolicy"]] = None,
        skip_verify: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Snapshots(_Model):
    """Grafana Snapshots settings.

    :ivar external_enabled: Set to false to disable external snapshot publish endpoint.
    :vartype external_enabled: bool
    """

    external_enabled: Optional[bool] = rest_field(
        name="externalEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set to false to disable external snapshot publish endpoint."""

    @overload
    def __init__(
        self,
        *,
        external_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubscriptionTerm(_Model):
    """The current billing term of the SaaS Subscription.

    :ivar term_unit: The unit of the billing term.
    :vartype term_unit: str
    :ivar start_date: The date and time in UTC of when the billing term starts.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The date and time in UTC of when the billing term ends.
    :vartype end_date: ~datetime.datetime
    """

    term_unit: Optional[str] = rest_field(name="termUnit", visibility=["read", "create", "update", "delete", "query"])
    """The unit of the billing term."""
    start_date: Optional[datetime.datetime] = rest_field(
        name="startDate", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The date and time in UTC of when the billing term starts."""
    end_date: Optional[datetime.datetime] = rest_field(
        name="endDate", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The date and time in UTC of when the billing term ends."""

    @overload
    def __init__(
        self,
        *,
        term_unit: Optional[str] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.dashboard.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.dashboard.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UnifiedAlertingScreenshots(_Model):
    """Grafana Unified Alerting Screenshots settings.

    :ivar capture_enabled: Set to false to disable capture screenshot in Unified Alert due to
     performance issue.
    :vartype capture_enabled: bool
    """

    capture_enabled: Optional[bool] = rest_field(
        name="captureEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set to false to disable capture screenshot in Unified Alert due to performance issue."""

    @overload
    def __init__(
        self,
        *,
        capture_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class Users(_Model):
    """Grafana users settings.

    :ivar viewers_can_edit: Set to true so viewers can access and use explore and perform temporary
     edits on panels in dashboards they have access to. They cannot save their changes.
    :vartype viewers_can_edit: bool
    :ivar editors_can_admin: Set to true so editors can administrate dashboards, folders and teams
     they create.
    :vartype editors_can_admin: bool
    """

    viewers_can_edit: Optional[bool] = rest_field(
        name="viewersCanEdit", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set to true so viewers can access and use explore and perform temporary edits on panels in
     dashboards they have access to. They cannot save their changes."""
    editors_can_admin: Optional[bool] = rest_field(
        name="editorsCanAdmin", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set to true so editors can administrate dashboards, folders and teams they create."""

    @overload
    def __init__(
        self,
        *,
        viewers_can_edit: Optional[bool] = None,
        editors_can_admin: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
