/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesReloadContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenSyncSpec;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenSyncListener;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "myProject", "Lcom/intellij/openapi/project/Project;", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;Lorg/jetbrains/idea/maven/project/MavenProjectsManager;)V", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "isSyncCompleted", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "settingsFiles", "", "", "getSettingsFiles", "()Ljava/util/Set;", "subscribe", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "reloadProject", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "collectSettingsFiles", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenProjectAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectAware.kt\norg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1563#2:111\n1634#2,3:112\n*S KotlinDebug\n*F\n+ 1 MavenProjectAware.kt\norg/jetbrains/idea/maven/project/auto/reload/MavenProjectAware\n*L\n80#1:111\n80#1:112,3\n*E\n"})
public final class MavenProjectAware
implements ExternalSystemProjectAware {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemProjectId projectId;
    @NotNull
    private final MavenProjectsManager manager;
    @NotNull
    private final AtomicBooleanProperty isSyncCompleted;

    public MavenProjectAware(@NotNull Project myProject, @NotNull ExternalSystemProjectId projectId, @NotNull MavenProjectsManager manager) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.myProject = myProject;
        this.projectId = projectId;
        this.manager = manager;
        this.isSyncCompleted = new AtomicBooleanProperty(true);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.manager).subscribe(MavenSyncListener.Companion.getTOPIC(), (Object)new MavenSyncListener(){

            @Override
            public void syncFinished(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (Intrinsics.areEqual((Object)myProject, (Object)project)) {
                    isSyncCompleted.set(true);
                }
            }

            @Override
            public void syncStarted(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (Intrinsics.areEqual((Object)myProject, (Object)project)) {
                    isSyncCompleted.set(false);
                }
            }
        });
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    @NotNull
    public Set<String> getSettingsFiles() {
        return this.collectSettingsFiles();
    }

    public void subscribe(@NotNull ExternalSystemProjectListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.isSyncCompleted.afterReset(parentDisposable, () -> MavenProjectAware.subscribe$lambda$0(listener2));
        this.isSyncCompleted.afterSet(parentDisposable, () -> MavenProjectAware.subscribe$lambda$1(listener2));
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MavenLog.LOG.debug("MavenProjectAware.reloadProject");
        ApplicationManager.getApplication().invokeAndWait(MavenProjectAware::reloadProject$lambda$0);
        if (context2.getHasUndefinedModifications()) {
            MavenLog.LOG.debug("MavenProjectAware.reloadProject - context.hasUndefinedModifications=true");
            MavenSyncSpec spec = MavenSyncSpec.Companion.incremental("MavenProjectAware.reloadProject, undefined modifications", context2.isExplicitReload());
            this.manager.scheduleUpdateAllMavenProjects(spec);
        } else {
            MavenLog.LOG.debug("MavenProjectAware.reloadProject - context.hasUndefinedModifications=false");
            ExternalSystemSettingsFilesReloadContext settingsFilesContext = context2.getSettingsFilesContext();
            List filesToUpdate = new ArrayList();
            List filesToDelete = new ArrayList();
            for (VirtualFile projectsFile : this.manager.getProjectsTree().getProjectsFiles()) {
                String path;
                Intrinsics.checkNotNullExpressionValue((Object)projectsFile.getPath(), (String)"getPath(...)");
                if (settingsFilesContext.getCreated().contains(path)) {
                    filesToUpdate.add(projectsFile);
                }
                if (settingsFilesContext.getUpdated().contains(path)) {
                    filesToUpdate.add(projectsFile);
                }
                if (!settingsFilesContext.getDeleted().contains(path)) continue;
                filesToDelete.add(projectsFile);
            }
            Set updated = SetsKt.plus((Set)settingsFilesContext.getCreated(), (Iterable)settingsFilesContext.getUpdated());
            Set deleted = settingsFilesContext.getDeleted();
            if (updated.size() == filesToUpdate.size() && deleted.size() == filesToDelete.size()) {
                spec = MavenSyncSpec.Companion.incremental("MavenProjectAware.reloadProject, sync selected", context2.isExplicitReload());
                this.manager.scheduleUpdateMavenProjects(spec, filesToUpdate, filesToDelete);
            } else {
                spec = MavenSyncSpec.Companion.incremental("MavenProjectAware.reloadProject, sync all", context2.isExplicitReload());
                this.manager.scheduleUpdateAllMavenProjects(spec);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> collectSettingsFiles() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        LinkedHashSet<CallSite> result2 = new LinkedHashSet<CallSite>();
        result2.addAll((Collection)this.manager.getProjectsTree().getManagedFilesPaths());
        Iterable iterable = this.manager.getProjectsTree().getProjectsFiles();
        LinkedHashSet<CallSite> linkedHashSet = result2;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        linkedHashSet.addAll((List)destination$iv$iv);
        for (MavenProject mavenProject : this.manager.getProjectsTree().getProjects()) {
            ProgressManager.checkCanceled();
            result2.addAll((Collection)mavenProject.getModulePaths());
            String rootDirectory = mavenProject.getDirectory();
            result2.add((CallSite)((Object)(rootDirectory + "/.mvn/jvm.config")));
            result2.add((CallSite)((Object)(rootDirectory + "/.mvn/maven.config")));
            result2.add((CallSite)((Object)(rootDirectory + "/.mvn/wrapper/maven-wrapper.properties")));
        }
        return result2;
    }

    private static final Unit subscribe$lambda$0(ExternalSystemProjectListener $listener) {
        $listener.onProjectReloadStart();
        return Unit.INSTANCE;
    }

    private static final Unit subscribe$lambda$1(ExternalSystemProjectListener $listener) {
        $listener.onProjectReloadFinish(ExternalSystemRefreshStatus.SUCCESS);
        return Unit.INSTANCE;
    }

    private static final void reloadProject$lambda$0() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }
}

