/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrMoveClassToCorrectPlaceFix
extends Intention {
    private static final Logger LOG = Logger.getInstance(GrMoveClassToCorrectPlaceFix.class);
    private final GrTypeDefinition myClass;

    public GrMoveClassToCorrectPlaceFix(GrTypeDefinition clazz) {
        this.myClass = clazz;
        LOG.assertTrue(!this.myClass.isAnonymous());
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("move.class.0.from.method", this.myClass.getName());
        if (string == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("move.class.from.method.family.name", new Object[0]);
        if (string == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(2);
        }
        return this.myClass.isValid();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        GrTypeDefinition containingClass;
        if (project == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(5);
        }
        GrTypeDefinition target = (containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myClass, GrTypeDefinition.class)) != null ? containingClass : this.myClass.getContainingFile();
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.movePsi((PsiNamedElement)this.myClass, (PsiNamedElement)target);
        if (intentionPreviewInfo == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(6);
        }
        return intentionPreviewInfo;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrTypeDefinition containingClass;
        if (element == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GrMoveClassToCorrectPlaceFix.$$$reportNull$$$0(8);
        }
        if ((containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myClass, GrTypeDefinition.class)) != null) {
            containingClass.add(this.myClass);
        } else {
            PsiFile containingFile = this.myClass.getContainingFile();
            PsiElement added = containingFile.add((PsiElement)this.myClass);
            PsiElement prevSibling = added.getPrevSibling();
            if (prevSibling != null && prevSibling.getNode().getElementType() != GroovyTokenTypes.mNLS) {
                containingFile.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", added.getNode());
            }
        }
        this.myClass.delete();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return GrMoveClassToCorrectPlaceFix.this.myClass.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/GrMoveClassToCorrectPlaceFix$1", "satisfiedBy"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GrMoveClassToCorrectPlaceFix";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrMoveClassToCorrectPlaceFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

