/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public final class GroovyReturnFromClosureCanBeImplicitInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.ref.statement.at.end.closure.can.be.made.implicit", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyReturnFromClosureCanBeImplicitInspection.$$$reportNull$$$0(0);
        }
        return new MakeReturnImplicitFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection", "buildFix"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            if (returnStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(returnStatement);
            GrExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrClosableBlock.class);
            if (closure == null) {
                return;
            }
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrMethod.class);
            if (containingMethod != null && PsiTreeUtil.isAncestor((PsiElement)closure, (PsiElement)containingMethod, (boolean)true)) {
                return;
            }
            if (!ControlFlowUtils.closureCompletesWithStatement(closure, returnStatement)) {
                return;
            }
            this.registerStatementError(returnStatement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection$Visitor", "visitReturnStatement"));
        }
    }

    private static class MakeReturnImplicitFix
    extends PsiUpdateModCommandQuickFix {
        private MakeReturnImplicitFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.make.return.implicit", new Object[0]);
            if (string == null) {
                MakeReturnImplicitFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement returnKeywordElement, @NotNull ModPsiUpdater updater) {
            GrReturnStatement returnStatement;
            if (project == null) {
                MakeReturnImplicitFix.$$$reportNull$$$0(1);
            }
            if (returnKeywordElement == null) {
                MakeReturnImplicitFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MakeReturnImplicitFix.$$$reportNull$$$0(3);
            }
            if ((returnStatement = (GrReturnStatement)returnKeywordElement.getParent()) == null) {
                return;
            }
            if (returnStatement.getReturnValue() == null) {
                return;
            }
            GroovyFix.replaceStatement((GrStatement)returnStatement, returnStatement.getReturnValue().getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection$MakeReturnImplicitFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnKeywordElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyReturnFromClosureCanBeImplicitInspection$MakeReturnImplicitFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

