/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nJ#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/datagrid/color/MultipleGradient;", "", "fractions", "", "colors", "", "Ljava/awt/Color;", "<init>", "([F[Ljava/awt/Color;)V", "normalizedIntervals", "", "[Ljava/lang/Float;", "gradients", "[[Ljava/awt/Color;", "getColor", "position", "interpolate", "rgb1", "", "rgb2", "(II)[Ljava/awt/Color;", "Companion", "intellij.grid.impl"})
public final class MultipleGradient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] fractions;
    @NotNull
    private Float[] normalizedIntervals;
    @NotNull
    private Color[][] gradients;
    public static final int GRADIENT_SIZE = 256;
    public static final int GRADIENT_SIZE_INDEX = 255;

    public MultipleGradient(@NotNull float[] fractions, @NotNull Color[] colors) {
        int n;
        Intrinsics.checkNotNullParameter((Object)fractions, (String)"fractions");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.fractions = fractions;
        int n2 = 0;
        int n3 = this.fractions.length - 1;
        Float[] floatArray = new Float[n3];
        MultipleGradient multipleGradient = this;
        while (n2 < n3) {
            n = n2++;
            floatArray[n] = Float.valueOf(this.fractions[n + 1] - this.fractions[n]);
        }
        multipleGradient.normalizedIntervals = floatArray;
        n2 = 0;
        n3 = this.normalizedIntervals.length;
        floatArray = new Color[n3][];
        multipleGradient = this;
        while (n2 < n3) {
            n = n2++;
            floatArray[n] = this.interpolate(colors[n].getRGB(), colors[n + 1].getRGB());
        }
        multipleGradient.gradients = floatArray;
    }

    @NotNull
    public final Color getColor(float position) {
        float pos = RangesKt.coerceIn((float)position, (float)0.0f, (float)1.0f);
        int n = ((Object[])this.gradients).length;
        for (int i = 0; i < n; ++i) {
            if (!(pos < this.fractions[i + 1])) continue;
            float delta = pos - this.fractions[i];
            int index = (int)(delta / this.normalizedIntervals[i].floatValue() * (float)255);
            return this.gradients[i][index];
        }
        return this.gradients[((Object[])this.gradients).length - 1][255];
    }

    private final Color[] interpolate(int rgb1, int rgb2) {
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int da = (rgb2 >> 24 & 0xFF) - a1;
        int dr = (rgb2 >> 16 & 0xFF) - r1;
        int dg = (rgb2 >> 8 & 0xFF) - g1;
        int db = (rgb2 & 0xFF) - b1;
        float stepSize = 0.00390625f;
        int n = 0;
        Color[] colorArray = new Color[256];
        while (n < 256) {
            int n2 = n++;
            int intColor = (int)((double)((float)a1 + (float)(n2 * da) * stepSize) + 0.5) << 24 | (int)((double)((float)r1 + (float)(n2 * dr) * stepSize) + 0.5) << 16 | (int)((double)((float)g1 + (float)(n2 * dg) * stepSize) + 0.5) << 8 | (int)((double)((float)b1 + (float)(n2 * db) * stepSize) + 0.5);
            colorArray[n2] = new Color(intColor);
        }
        return colorArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/datagrid/color/MultipleGradient$Companion;", "", "<init>", "()V", "GRADIENT_SIZE", "", "GRADIENT_SIZE_INDEX", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

