/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import com.intellij.vcs.log.ui.table.column.VcsLogCustomColumn;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ToggleLogColumnsActionGroup
extends ActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setPopupGroup(ToggleLogColumnsActionGroup.isPopup(e));
        e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        ArrayList<Object> actions2 = new ArrayList<Object>();
        if (e != null && !ToggleLogColumnsActionGroup.isPopup(e)) {
            actions2.add(Separator.create((String)VcsLogBundle.message("group.Vcs.Log.ToggleColumns.text", new Object[0])));
        }
        List<VcsLogColumn<?>> dynamicColumns = VcsLogColumnUtilKt.getDynamicColumns();
        for (VcsLogColumn<?> column : dynamicColumns) {
            actions2.add((Object)new ToggleColumnAction(column));
        }
        AnAction[] anActionArray = actions2.toArray(EMPTY_ARRAY);
        if (anActionArray == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static boolean isPopup(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(3);
        }
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) == null;
    }

    private static boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        VcsLogUiProperties properties;
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(4);
        }
        return (properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null && VcsLogColumnUtilKt.supportsColumnsToggling(properties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPopup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledAndVisible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class ToggleColumnAction
    extends ToggleAction
    implements DumbAware {
        private final VcsLogColumn<?> myColumn;

        private ToggleColumnAction(@NotNull VcsLogColumn<?> column) {
            if (column == null) {
                ToggleColumnAction.$$$reportNull$$$0(0);
            }
            super(() -> column.getLocalizedName());
            this.myColumn = column;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(1);
            }
            if (!this.isColumnAvailable(e)) {
                return false;
            }
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            if (properties != null) {
                return VcsLogColumnUtilKt.isVisible(this.myColumn, properties);
            }
            return false;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(2);
            }
            VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
            if (!this.isColumnAvailable(e)) {
                return;
            }
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            if (properties == null) {
                return;
            }
            assert (VcsLogColumnUtilKt.supportsColumnsToggling(properties));
            if (state) {
                VcsLogColumnUtilKt.addColumn(properties, this.myColumn);
            } else {
                VcsLogColumnUtilKt.removeColumn(properties, this.myColumn);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e) && this.isColumnAvailable(e));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleColumnAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        private boolean isColumnAvailable(@NotNull AnActionEvent e) {
            VcsLogColumn<?> vcsLogColumn;
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(5);
            }
            if ((vcsLogColumn = this.myColumn) instanceof VcsLogCustomColumn) {
                VcsLogCustomColumn customColumn = (VcsLogCustomColumn)vcsLogColumn;
                VcsLogData logData = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
                return logData != null && VcsLogCustomColumn.isAvailable(customColumn, logData);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup$ToggleColumnAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup$ToggleColumnAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isColumnAvailable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

