/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.local;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyUnusedImportUtil;
import org.jetbrains.plugins.groovy.util.GroovyMainMethodSearcher;

public class GroovyPostHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    private final GroovyFile myFile;
    @NotNull
    private final Editor myEditor;
    private volatile Set<GrImportStatement> myUnusedImports;
    private volatile List<HighlightInfo> myUnusedDeclarations;

    GroovyPostHighlightingPass(@NotNull GroovyFile file, @NotNull Editor editor) {
        if (file == null) {
            GroovyPostHighlightingPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GroovyPostHighlightingPass.$$$reportNull$$$0(1);
        }
        super(file.getProject(), editor.getDocument(), true);
        this.myFile = file;
        this.myEditor = editor;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        VirtualFile virtualFile;
        ProjectFileIndex fileIndex;
        if (progress == null) {
            GroovyPostHighlightingPass.$$$reportNull$$$0(2);
        }
        if (!(fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex()).isInContent(virtualFile = this.myFile.getViewProvider().getVirtualFile())) {
            return;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)this.myProject).getCurrentProfile();
        final HighlightDisplayKey unusedDefKey = HighlightDisplayKey.find((String)"GroovyUnusedDeclaration");
        final boolean deadCodeEnabled = profile.isToolEnabled(unusedDefKey, (PsiElement)this.myFile);
        UnusedDeclarationInspectionBase deadCodeInspection = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool("unused", (PsiElement)this.myFile);
        final GroovyUsageHelper usageHelper = new GroovyUsageHelper(deadCodeInspection);
        final ArrayList<HighlightInfo> unusedDeclarations = new ArrayList<HighlightInfo>();
        final HashMap usedParams = new HashMap();
        this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof GrReferenceExpression && !((GrReferenceElement)element).isQualified()) {
                    results = ((GrReferenceExpression)element).multiResolve(false);
                    if (results.length == 0) {
                        results = ((GrReferenceExpression)element).multiResolve(true);
                    }
                    for (GroovyResolveResult result : results) {
                        resolved = result.getElement();
                        if (!(resolved instanceof GrParameter) || resolved.getContainingFile() != GroovyPostHighlightingPass.this.myFile) continue;
                        usedParams.put((GrParameter)resolved, Boolean.TRUE);
                    }
                }
                if (deadCodeEnabled && element instanceof GrNamedElement && element instanceof PsiModifierListOwner && !UnusedSymbolUtil.isImplicitUsage((Project)element.getProject(), (PsiModifierListOwner)((PsiModifierListOwner)element)) && !GroovySuppressableInspectionTool.isElementToolSuppressedIn(element, "GroovyUnusedDeclaration") && (nameId = ((GrNamedElement)element).getNameIdentifierGroovy()).getNode().getElementType() == GroovyTokenTypes.mIDENT) {
                    name = ((GrNamedElement)element).getName();
                    if (element instanceof GrTypeDefinition && !UnusedSymbolUtil.isClassUsed((Project)GroovyPostHighlightingPass.access$000(GroovyPostHighlightingPass.this), (PsiFile)element.getContainingFile(), (PsiClass)((GrTypeDefinition)element), (GlobalUsageHelper)usageHelper)) {
                        builder = UnusedSymbolUtil.createUnusedSymbolInfoBuilder((PsiElement)nameId, (String)GroovyBundle.message("text.class.0.is.unused", new Object[]{name}), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL, (String)"GroovyUnusedDeclaration");
                        action = QuickFixFactory.getInstance().createSafeDeleteFix(element);
                        builder.registerFix(action, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)unusedDefKey), null, unusedDefKey);
                        ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)builder.create());
                    } else if (element instanceof GrMethod) {
                        method = (GrMethod)element;
                        if (SpockUtils.isUnusedInSpock(method, usageHelper)) {
                            usageHelper.shouldCheckContributors = false;
                        }
                        try {
                            if (UnusedSymbolUtil.isMethodUsed((Project)method.getProject(), (PsiFile)method.getContainingFile(), (PsiMethod)method, (GlobalUsageHelper)usageHelper)) ** GOTO lbl48
                            message = method.isConstructor() != false ? GroovyBundle.message("text.constructor.0.is.unused", new Object[]{name}) : GroovyBundle.message("text.method.0.is.unused", new Object[]{name});
                            builder = UnusedSymbolUtil.createUnusedSymbolInfoBuilder((PsiElement)nameId, (String)message, (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL, (String)"GroovyUnusedDeclaration");
                            action = QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)method);
                            builder.registerFix(action, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)unusedDefKey), null, unusedDefKey);
                            ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)builder.create());
                        }
                        finally {
                            usageHelper.shouldCheckContributors = true;
                        }
                    } else if (element instanceof GrField && GroovyPostHighlightingPass.isFieldUnused((GrField)element, usageHelper)) {
                        builder = UnusedSymbolUtil.createUnusedSymbolInfoBuilder((PsiElement)nameId, (String)GroovyBundle.message("text.property.0.is.unused", new Object[]{name}), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL, (String)"GroovyUnusedDeclaration");
                        action = QuickFixFactory.getInstance().createSafeDeleteFix(element);
                        builder.registerFix(action, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)unusedDefKey), null, unusedDefKey);
                        ContainerUtil.addIfNotNull((Collection)unusedDeclarations, (Object)builder.create());
                    } else if (element instanceof GrParameter && !usedParams.containsKey(element)) {
                        usedParams.put((GrParameter)element, Boolean.FALSE);
                    }
                }
lbl48:
                // 9 sources

                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/codeInspection/local/GroovyPostHighlightingPass$1", "visitElement"));
            }
        });
        Set<GrImportStatement> unusedImports = GroovyUnusedImportUtil.unusedImports(this.myFile);
        this.myUnusedImports = unusedImports;
        if (deadCodeEnabled) {
            for (GrParameter parameter : usedParams.keySet()) {
                if (((Boolean)usedParams.get(parameter)).booleanValue()) continue;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof GrMethod) {
                    GrMethod method = (GrMethod)scope;
                    if (!GroovyPostHighlightingPass.methodMayHaveUnusedParameters(method)) continue;
                    PsiElement identifier = parameter.getNameIdentifierGroovy();
                    HighlightInfo.Builder builder = UnusedSymbolUtil.createUnusedSymbolInfoBuilder((PsiElement)identifier, (String)GroovyBundle.message("text.parameter.0.is.unused", parameter.getName()), (HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL, (String)"GroovyUnusedDeclaration");
                    IntentionAction action = GroovyQuickFixFactory.getInstance().createRemoveUnusedGrParameterFix(parameter);
                    builder.registerFix(action, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)unusedDefKey), null, unusedDefKey);
                    ContainerUtil.addIfNotNull(unusedDeclarations, (Object)builder.create());
                    continue;
                }
                if (!(scope instanceof GrClosableBlock)) continue;
            }
        }
        this.myUnusedDeclarations = unusedDeclarations;
        List<HighlightInfo> infos = GroovyPostHighlightingPass.convertUnusedImportsToInfos(unusedDeclarations, unusedImports);
        BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.myFile, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), infos, (int)this.getId());
    }

    public void doApplyInformationToEditor() {
        Set<GrImportStatement> unusedImports = this.myUnusedImports;
        if (this.myUnusedDeclarations != null && unusedImports != null) {
            this.optimizeImports(unusedImports);
        }
    }

    private static boolean methodMayHaveUnusedParameters(GrMethod method) {
        return (method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static") || !method.hasModifierProperty("abstract") && !GroovyPostHighlightingPass.isOverriddenOrOverrides(method)) && !method.hasModifierProperty("native") && !JavaHighlightUtil.isSerializationRelatedMethod((PsiMethod)method, (PsiClass)method.getContainingClass());
    }

    private static boolean isFieldUnused(GrField field2, GlobalUsageHelper usageHelper) {
        if (UnusedSymbolUtil.isFieldUsed((Project)field2.getProject(), (PsiFile)field2.getContainingFile(), (PsiField)field2, (GlobalUsageHelper)usageHelper)) {
            return false;
        }
        GrAccessorMethod[] getters = field2.getGetters();
        GrAccessorMethod setter = field2.getSetter();
        for (GrAccessorMethod getter : getters) {
            if (getter.findSuperMethods().length <= 0) continue;
            return false;
        }
        if (setter != null && setter.findSuperMethods().length > 0) {
            return false;
        }
        return !UnusedSymbolUtil.isImplicitRead((PsiVariable)field2) && !UnusedSymbolUtil.isImplicitWrite((PsiVariable)field2);
    }

    private static boolean isOverriddenOrOverrides(PsiMethod method) {
        boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
        return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    private void optimizeImports(@NotNull Collection<GrImportStatement> unusedImports) {
        IntentionAction fix;
        if (unusedImports == null) {
            GroovyPostHighlightingPass.$$$reportNull$$$0(3);
        }
        if (!unusedImports.isEmpty() && (fix = GroovyQuickFixFactory.getInstance().createOptimizeImportsFix(true)).isAvailable(this.myProject, this.myEditor, (PsiFile)this.myFile) && this.myFile.isWritable()) {
            fix.invoke(this.myProject, this.myEditor, (PsiFile)this.myFile);
        }
    }

    @NotNull
    private static List<HighlightInfo> convertUnusedImportsToInfos(@NotNull List<? extends HighlightInfo> unusedDeclarations, @NotNull Set<? extends GrImportStatement> unusedImports) {
        if (unusedDeclarations == null) {
            GroovyPostHighlightingPass.$$$reportNull$$$0(4);
        }
        if (unusedImports == null) {
            GroovyPostHighlightingPass.$$$reportNull$$$0(5);
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(unusedDeclarations);
        for (GrImportStatement grImportStatement : unusedImports) {
            IntentionAction action = GroovyQuickFixFactory.getInstance().createOptimizeImportsFix(false);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL).range(GroovyPostHighlightingPass.calculateRangeToUse(grImportStatement)).descriptionAndTooltip(GroovyBundle.message("unused.import", new Object[0])).registerFix(action, List.of(), null, null, null).create();
            if (info == null) continue;
            infos.add(info);
        }
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            GroovyPostHighlightingPass.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static TextRange calculateRangeToUse(GrImportStatement unusedImport) {
        TextRange range = unusedImport.getTextRange();
        if (StringUtil.isEmptyOrSpaces((String)unusedImport.getAnnotationList().getText())) {
            return range;
        }
        int start = 0;
        for (PsiElement child = unusedImport.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() != GroovyTokenTypes.kIMPORT) continue;
            start = child.getTextRange().getStartOffset();
        }
        return new TextRange(start, range.getEndOffset());
    }

    private static boolean isMainMethod(@NotNull PsiElement element) {
        if (element == null) {
            GroovyPostHighlightingPass.$$$reportNull$$$0(7);
        }
        if (!(element instanceof GrMethod)) {
            return false;
        }
        GrMethod method = (GrMethod)element;
        return method.getName().equals("main") && GroovyMainMethodSearcher.INSTANCE.isMainMethod(method);
    }

    static /* synthetic */ Project access$000(GroovyPostHighlightingPass x0) {
        return x0.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedImports";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedDeclarations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/local/GroovyPostHighlightingPass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/local/GroovyPostHighlightingPass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertUnusedImportsToInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertUnusedImportsToInfos";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMainMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static class GroovyUsageHelper
    extends GlobalUsageHelper {
        private boolean shouldCheckContributors = true;
        private final UnusedDeclarationInspectionBase deadCodeInspection;

        private GroovyUsageHelper(UnusedDeclarationInspectionBase inspection) {
            this.deadCodeInspection = inspection;
        }

        public boolean isCurrentFileAlreadyChecked() {
            return false;
        }

        public boolean isLocallyUsed(@NotNull PsiNamedElement member) {
            if (member == null) {
                GroovyUsageHelper.$$$reportNull$$$0(0);
            }
            return false;
        }

        public boolean shouldCheckUsages(@NotNull PsiMember member) {
            if (member == null) {
                GroovyUsageHelper.$$$reportNull$$$0(1);
            }
            if (this.shouldCheckContributors) {
                if (GroovyPostHighlightingPass.isMainMethod((PsiElement)member)) {
                    return false;
                }
                return this.deadCodeInspection == null || !this.deadCodeInspection.isEntryPoint((PsiElement)member);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "member";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/local/GroovyPostHighlightingPass$GroovyUsageHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLocallyUsed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldCheckUsages";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

