/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B6\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0011\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001d\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00028\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\"J\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010&*\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010)R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractChopListIntention;", "TList", "Lorg/jetbrains/kotlin/psi/KtElement;", "TElement", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "listClass", "Ljava/lang/Class;", "elementClass", "textGetter", "Ljava/util/function/Supplier;", "", "Lcom/intellij/codeInspection/util/IntentionName;", "<init>", "(Ljava/lang/Class;Ljava/lang/Class;Ljava/util/function/Supplier;)V", "visitTargetTypeOnlyOnce", "", "leftParOnNewLine", "commonCodeStyleSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "rightParOnNewLine", "isApplicableTo", "element", "caretOffset", "", "(Lorg/jetbrains/kotlin/psi/KtElement;I)Z", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/openapi/editor/Editor;)V", "hasLineBreakAfter", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "nextBreak", "Lcom/intellij/psi/PsiWhiteSpace;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lcom/intellij/psi/PsiWhiteSpace;", "hasLineBreakBefore", "prevBreak", "elements", "", "(Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/util/List;", "isApplicableCaretOffset", "(ILorg/jetbrains/kotlin/psi/KtElement;)Z", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nChopParameterListIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChopParameterListIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractChopListIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1740#2,3:128\n320#3,7:131\n183#3,2:139\n183#3,2:141\n1#4:138\n*S KotlinDebug\n*F\n+ 1 ChopParameterListIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/AbstractChopListIntention\n*L\n38#1:128,3\n53#1:131,7\n73#1:139,2\n79#1:141,2\n*E\n"})
public abstract class AbstractChopListIntention<TList extends KtElement, TElement extends KtElement>
extends SelfTargetingIntention<TList> {
    @NotNull
    private final Class<TElement> elementClass;

    public AbstractChopListIntention(@NotNull Class<TList> listClass, @NotNull Class<TElement> elementClass, @NotNull Supplier<String> textGetter) {
        Intrinsics.checkNotNullParameter(listClass, (String)"listClass");
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        super(listClass, textGetter, null, 4, null);
        this.elementClass = elementClass;
    }

    @Override
    protected boolean visitTargetTypeOnlyOnce() {
        return true;
    }

    public boolean leftParOnNewLine(@NotNull CommonCodeStyleSettings commonCodeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)commonCodeStyleSettings, (String)"commonCodeStyleSettings");
        return false;
    }

    public boolean rightParOnNewLine(@NotNull CommonCodeStyleSettings commonCodeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)commonCodeStyleSettings, (String)"commonCodeStyleSettings");
        return false;
    }

    @Override
    public boolean isApplicableTo(@NotNull TList element, int caretOffset) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            List<TElement> elements = this.elements(element);
            if (elements.size() <= 1) {
                return false;
            }
            if (!this.isApplicableCaretOffset(caretOffset, element)) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.dropLast(elements, (int)1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtElement it = (KtElement)element$iv;
                    boolean bl2 = false;
                    if (this.hasLineBreakAfter(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return !bl;
    }

    @Override
    public void applyTo(@NotNull TList element, @Nullable Editor editor) {
        block5: {
            Sequence $this$lastOrNull$iv;
            Intrinsics.checkNotNullParameter(element, (String)"element");
            Project project = ((PsiElement)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getDocument()) == null) {
                return;
            }
            Editor document = editor2;
            SmartPsiElementPointer pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)element));
            CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
            KotlinCommonCodeStyleSettings commonCodeStyleSettings = CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)codeStyleSettings);
            boolean leftParOnNewLine = this.leftParOnNewLine((CommonCodeStyleSettings)commonCodeStyleSettings);
            boolean rightParOnNewLine = this.rightParOnNewLine((CommonCodeStyleSettings)commonCodeStyleSettings);
            List<TElement> elements = this.elements(element);
            if (rightParOnNewLine && !this.hasLineBreakAfter((KtElement)CollectionsKt.last(elements))) {
                $this$lastOrNull$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)element));
                boolean $i$f$lastOrNull = false;
                Object last$iv = null;
                for (Object element$iv : $this$lastOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.RPAR)) continue;
                    last$iv = element$iv;
                }
                PsiElement psiElement = last$iv;
                if (psiElement != null) {
                    int it = PsiUtilsKt.getStartOffset((PsiElement)psiElement);
                    boolean bl = false;
                    document.insertString(it, (CharSequence)"\n");
                }
            }
            int maxIndex = elements.size() - 1;
            $this$lastOrNull$iv = ((Iterable)CollectionsKt.asReversed(elements)).iterator();
            int n = 0;
            while ($this$lastOrNull$iv.hasNext()) {
                int index2 = n++;
                KtElement e = (KtElement)$this$lastOrNull$iv.next();
                if (index2 == maxIndex && !leftParOnNewLine) break;
                if (this.hasLineBreakBefore(e)) continue;
                document.insertString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)e)), (CharSequence)"\n");
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            documentManager.commitDocument((Document)document);
            KtElement ktElement = (KtElement)pointer.getElement();
            if (ktElement == null) break block5;
            GenericPsiUtils.reformatted$default((PsiElement)ktElement, false, 1, null);
        }
    }

    protected final boolean hasLineBreakAfter(@NotNull TElement element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.nextBreak(element) != null;
    }

    @Nullable
    protected final PsiWhiteSpace nextBreak(@NotNull TElement element) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            Sequence $this$firstOrNull$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)((PsiElement)element), (boolean)false, (boolean)false, (int)1, null), arg_0 -> AbstractChopListIntention.nextBreak$lambda$0(this, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var2_8 = v0;
        return var2_8 instanceof PsiWhiteSpace ? (PsiWhiteSpace)var2_8 : null;
    }

    protected final boolean hasLineBreakBefore(@NotNull TElement element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.prevBreak(element) != null;
    }

    @Nullable
    protected final PsiWhiteSpace prevBreak(@NotNull TElement element) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            Sequence $this$firstOrNull$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)element), (boolean)false, (boolean)false), arg_0 -> AbstractChopListIntention.prevBreak$lambda$0(this, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var2_8 = v0;
        return var2_8 instanceof PsiWhiteSpace ? (PsiWhiteSpace)var2_8 : null;
    }

    @NotNull
    protected final List<TElement> elements(@NotNull TList $this$elements) {
        Intrinsics.checkNotNullParameter($this$elements, (String)"<this>");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$elements))), arg_0 -> AbstractChopListIntention.elements$lambda$0(this, arg_0)), AbstractChopListIntention::elements$lambda$1));
    }

    protected final boolean isApplicableCaretOffset(int caretOffset, @NotNull TList element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        PsiElement psiElement = ((PsiElement)element).getContainingFile().findElementAt(caretOffset - 1);
        if (psiElement == null) {
            return true;
        }
        PsiElement elementBeforeCaret = psiElement;
        if (!Intrinsics.areEqual((Object)elementBeforeCaret.getNode().getElementType(), (Object)KtTokens.RPAR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)elementBeforeCaret.getParent(), element);
    }

    private static final boolean nextBreak$lambda$0(AbstractChopListIntention this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.elementClass.isInstance(it);
    }

    private static final boolean prevBreak$lambda$0(AbstractChopListIntention this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.elementClass.isInstance(it);
    }

    private static final boolean elements$lambda$0(AbstractChopListIntention this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.elementClass.isInstance(it);
    }

    private static final KtElement elements$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (KtElement)it;
    }
}

