/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatEditor;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvRecordFormatForm;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatForm
implements Disposable,
CsvFormatEditor {
    private JPanel myPanel;
    private JBCheckBox myHeaderFormatCheckBox;
    private JPanel myRecordFormatPanel;
    private JPanel myHeaderFormatPanel;
    private JBCheckBox myRowNumbersCheckBox;
    private JPanel myHeaderFormatWithTitlePanel;
    private String myFormatName;
    private CsvRecordFormatForm myRecordFormatForm;
    private CsvRecordFormatForm myHeaderFormatForm;
    private boolean myResetting;
    private final EventDispatcher<ChangeListener> myEventDispatcher;
    private CsvFormat myFormat;

    public CsvFormatForm(@NotNull Disposable parent, final @NotNull CsvFormatUISettings settings) {
        if (parent == null) {
            CsvFormatForm.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CsvFormatForm.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myHeaderFormatCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean headerEnabled = CsvFormatForm.this.myHeaderFormatCheckBox.isSelected();
                CsvFormatForm.this.myHeaderFormatWithTitlePanel.setVisible(headerEnabled && settings.isHeaderSettingsVisible());
                if (headerEnabled) {
                    CsvFormatForm.this.myHeaderFormatForm.reset(CsvFormatForm.this.myRecordFormatForm.getFormat());
                } else {
                    CsvFormatForm.this.fireFormatChangedEvent();
                }
            }
        });
        this.myRowNumbersCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CsvFormatForm.this.fireFormatChangedEvent();
            }
        });
        CsvRecordFormatForm.ChangeListener changeEventPropagator = new CsvRecordFormatForm.ChangeListener(){

            @Override
            public void recordFormatChanged(@NotNull CsvRecordFormatForm source) {
                if (source == null) {
                    3.$$$reportNull$$$0(0);
                }
                CsvFormatForm.this.fireFormatChangedEvent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/csv/ui/CsvFormatForm$3", "recordFormatChanged"));
            }
        };
        this.myHeaderFormatForm.addChangeListener(changeEventPropagator);
        this.myRecordFormatForm.addChangeListener(changeEventPropagator);
        this.myHeaderFormatWithTitlePanel.setVisible(false);
    }

    private void createUIComponents() {
        this.myRecordFormatForm = new CsvRecordFormatForm(this);
        this.myHeaderFormatForm = new CsvRecordFormatForm(this);
        this.myRecordFormatPanel = this.myRecordFormatForm.getMainPanel();
        this.myHeaderFormatPanel = this.myHeaderFormatForm.getMainPanel();
    }

    public void reset(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatForm.$$$reportNull$$$0(2);
        }
        this.myFormat = format;
        this.myResetting = true;
        try {
            this.myFormatName = format.name;
            this.myRecordFormatForm.reset(format.dataRecord);
            this.setHeaderFormat(format.headerRecord);
            this.myRowNumbersCheckBox.setSelected(format.rowNumbers);
        }
        finally {
            this.myResetting = false;
            this.fireFormatChangedEvent();
        }
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvRecordFormat dataFormat = this.myRecordFormatForm.getFormat();
        CsvRecordFormat headerFormat = this.myHeaderFormatCheckBox.isSelected() ? this.myHeaderFormatForm.getFormat() : null;
        return new CsvFormat(this.myFormatName, dataFormat, headerFormat, this.myFormat.id, this.myRowNumbersCheckBox.isSelected());
    }

    public void addChangeListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            CsvFormatForm.$$$reportNull$$$0(3);
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void addChangeListener(@NotNull ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            CsvFormatForm.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            CsvFormatForm.$$$reportNull$$$0(5);
        }
        this.myEventDispatcher.addListener((EventListener)listener, parent);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CsvFormatForm.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    public void dispose() {
    }

    private void fireFormatChangedEvent() {
        if (!this.myResetting) {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).formatChanged(this);
        }
    }

    private void setHeaderFormat(@Nullable CsvRecordFormat headerFormat) {
        this.myHeaderFormatCheckBox.setSelected(headerFormat != null);
        if (headerFormat != null) {
            this.myHeaderFormatForm.reset(headerFormat);
        }
    }

    public boolean firstRowIsHeader() {
        return this.myHeaderFormatCheckBox.isSelected();
    }

    public void setFirstRowIsHeader(boolean value) {
        this.myHeaderFormatCheckBox.setSelected(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatForm";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = this.myRecordFormatPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRowNumbersCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvFormatForm.class).getString("csv.format.settings.first.column.is.header"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeaderFormatCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvFormatForm.class).getString("csv.format.settings.first.row.is.header"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeaderFormatWithTitlePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvFormatForm.class).getString("csv.format.settings.header.format.label"));
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        JPanel jPanel5 = this.myHeaderFormatPanel;
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void formatChanged(@NotNull CsvFormatForm var1);
    }
}

