/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.passay.dictionary.AbstractFileWordList;

public class FileWordList
extends AbstractFileWordList {
    private static final int READ_BUFSIZE = 8192;
    private final byte[] bytes = new byte[8192];
    private final Buffer buffer = ByteBuffer.wrap(this.bytes);

    public FileWordList(RandomAccessFile raf) throws IOException {
        this(raf, true);
    }

    public FileWordList(RandomAccessFile raf, boolean caseSensitive) throws IOException {
        this(raf, caseSensitive, 5);
    }

    public FileWordList(RandomAccessFile raf, boolean caseSensitive, int cachePercent) throws IOException {
        this(raf, caseSensitive, cachePercent, StandardCharsets.UTF_8.newDecoder());
    }

    public FileWordList(RandomAccessFile raf, boolean caseSensitive, int cachePercent, CharsetDecoder decoder) throws IOException {
        this(raf, caseSensitive, cachePercent, decoder, false);
    }

    public FileWordList(RandomAccessFile raf, boolean caseSensitive, int cachePercent, CharsetDecoder decoder, boolean allocateDirect) throws IOException {
        super(raf, caseSensitive, decoder);
        this.initialize(cachePercent, allocateDirect);
    }

    @Override
    protected void seek(long offset) throws IOException {
        this.file.seek(offset);
        this.buffer.clear();
        this.fill();
    }

    @Override
    protected ByteBuffer buffer() {
        return (ByteBuffer)this.buffer;
    }

    @Override
    protected void fill() throws IOException {
        this.buffer.clear();
        int count = this.file.read(this.bytes);
        this.buffer.limit(count > 0 ? count : 0);
    }
}

