﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/bedrock-runtime/model/ConverseMetrics.h>
#include <aws/bedrock-runtime/model/ConverseOutput.h>
#include <aws/bedrock-runtime/model/ConverseTrace.h>
#include <aws/bedrock-runtime/model/PerformanceConfiguration.h>
#include <aws/bedrock-runtime/model/ServiceTier.h>
#include <aws/bedrock-runtime/model/StopReason.h>
#include <aws/bedrock-runtime/model/TokenUsage.h>
#include <aws/core/utils/Document.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace BedrockRuntime {
namespace Model {
class ConverseResult {
 public:
  AWS_BEDROCKRUNTIME_API ConverseResult() = default;
  AWS_BEDROCKRUNTIME_API ConverseResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BEDROCKRUNTIME_API ConverseResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The result from the call to <code>Converse</code>.</p>
   */
  inline const ConverseOutput& GetOutput() const { return m_output; }
  template <typename OutputT = ConverseOutput>
  void SetOutput(OutputT&& value) {
    m_outputHasBeenSet = true;
    m_output = std::forward<OutputT>(value);
  }
  template <typename OutputT = ConverseOutput>
  ConverseResult& WithOutput(OutputT&& value) {
    SetOutput(std::forward<OutputT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason why the model stopped generating output.</p>
   */
  inline StopReason GetStopReason() const { return m_stopReason; }
  inline void SetStopReason(StopReason value) {
    m_stopReasonHasBeenSet = true;
    m_stopReason = value;
  }
  inline ConverseResult& WithStopReason(StopReason value) {
    SetStopReason(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The total number of tokens used in the call to <code>Converse</code>. The
   * total includes the tokens input to the model and the tokens generated by the
   * model.</p>
   */
  inline const TokenUsage& GetUsage() const { return m_usage; }
  template <typename UsageT = TokenUsage>
  void SetUsage(UsageT&& value) {
    m_usageHasBeenSet = true;
    m_usage = std::forward<UsageT>(value);
  }
  template <typename UsageT = TokenUsage>
  ConverseResult& WithUsage(UsageT&& value) {
    SetUsage(std::forward<UsageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Metrics for the call to <code>Converse</code>.</p>
   */
  inline const ConverseMetrics& GetMetrics() const { return m_metrics; }
  template <typename MetricsT = ConverseMetrics>
  void SetMetrics(MetricsT&& value) {
    m_metricsHasBeenSet = true;
    m_metrics = std::forward<MetricsT>(value);
  }
  template <typename MetricsT = ConverseMetrics>
  ConverseResult& WithMetrics(MetricsT&& value) {
    SetMetrics(std::forward<MetricsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Additional fields in the response that are unique to the model. </p>
   */
  inline Aws::Utils::DocumentView GetAdditionalModelResponseFields() const { return m_additionalModelResponseFields; }
  template <typename AdditionalModelResponseFieldsT = Aws::Utils::Document>
  void SetAdditionalModelResponseFields(AdditionalModelResponseFieldsT&& value) {
    m_additionalModelResponseFieldsHasBeenSet = true;
    m_additionalModelResponseFields = std::forward<AdditionalModelResponseFieldsT>(value);
  }
  template <typename AdditionalModelResponseFieldsT = Aws::Utils::Document>
  ConverseResult& WithAdditionalModelResponseFields(AdditionalModelResponseFieldsT&& value) {
    SetAdditionalModelResponseFields(std::forward<AdditionalModelResponseFieldsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A trace object that contains information about the Guardrail behavior.</p>
   */
  inline const ConverseTrace& GetTrace() const { return m_trace; }
  template <typename TraceT = ConverseTrace>
  void SetTrace(TraceT&& value) {
    m_traceHasBeenSet = true;
    m_trace = std::forward<TraceT>(value);
  }
  template <typename TraceT = ConverseTrace>
  ConverseResult& WithTrace(TraceT&& value) {
    SetTrace(std::forward<TraceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Model performance settings for the request.</p>
   */
  inline const PerformanceConfiguration& GetPerformanceConfig() const { return m_performanceConfig; }
  template <typename PerformanceConfigT = PerformanceConfiguration>
  void SetPerformanceConfig(PerformanceConfigT&& value) {
    m_performanceConfigHasBeenSet = true;
    m_performanceConfig = std::forward<PerformanceConfigT>(value);
  }
  template <typename PerformanceConfigT = PerformanceConfiguration>
  ConverseResult& WithPerformanceConfig(PerformanceConfigT&& value) {
    SetPerformanceConfig(std::forward<PerformanceConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the processing tier configuration used for serving the request.</p>
   */
  inline const ServiceTier& GetServiceTier() const { return m_serviceTier; }
  template <typename ServiceTierT = ServiceTier>
  void SetServiceTier(ServiceTierT&& value) {
    m_serviceTierHasBeenSet = true;
    m_serviceTier = std::forward<ServiceTierT>(value);
  }
  template <typename ServiceTierT = ServiceTier>
  ConverseResult& WithServiceTier(ServiceTierT&& value) {
    SetServiceTier(std::forward<ServiceTierT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ConverseResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ConverseOutput m_output;

  StopReason m_stopReason{StopReason::NOT_SET};

  TokenUsage m_usage;

  ConverseMetrics m_metrics;

  Aws::Utils::Document m_additionalModelResponseFields;

  ConverseTrace m_trace;

  PerformanceConfiguration m_performanceConfig;

  ServiceTier m_serviceTier;

  Aws::String m_requestId;
  bool m_outputHasBeenSet = false;
  bool m_stopReasonHasBeenSet = false;
  bool m_usageHasBeenSet = false;
  bool m_metricsHasBeenSet = false;
  bool m_additionalModelResponseFieldsHasBeenSet = false;
  bool m_traceHasBeenSet = false;
  bool m_performanceConfigHasBeenSet = false;
  bool m_serviceTierHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockRuntime
}  // namespace Aws
