/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDNull;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ExecuteBatchImpl
implements DBSDataManipulator.ExecuteBatch {
    private static final Log log = Log.getLog(ExecuteBatchImpl.class);
    protected final DBSAttributeBase[] attributes;
    protected final List<Object[]> values = new ArrayList<Object[]>();
    protected final DBDDataReceiver keysReceiver;
    protected final boolean reuseStatement;

    protected ExecuteBatchImpl(@NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, boolean reuseStatement) {
        this.attributes = attributes;
        this.keysReceiver = keysReceiver;
        this.reuseStatement = reuseStatement;
    }

    @Override
    public void add(@NotNull Object[] attributeValues) throws DBCException {
        if (!ArrayUtils.isEmpty((Object[])this.attributes) && ArrayUtils.isEmpty((Object[])attributeValues)) {
            throw new DBCException("Bad attribute values: " + Arrays.toString(attributeValues));
        }
        this.values.add(attributeValues);
    }

    @Override
    @NotNull
    public DBCStatistics execute(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        return this.processBatch(session, null, options);
    }

    @Override
    @NotNull
    public void generatePersistActions(@NotNull DBCSession session, @NotNull List<DBEPersistAction> actions, @NotNull Map<String, Object> options) throws DBException {
        this.processBatch(session, actions, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    DBCStatistics processBatch(@NotNull DBCSession session, @Nullable List<DBEPersistAction> actions, Map<String, Object> options) throws DBException {
        boolean skipBindValues;
        boolean useBatch;
        DBDValueHandler[] handlers = new DBDValueHandler[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            handlers[i] = this.attributes[i] instanceof DBDAttributeBinding ? ((DBDAttributeBinding)this.attributes[i]).getValueHandler() : DBUtils.findValueHandler(session, (DBSTypedObject)this.attributes[i]);
        }
        boolean bl = useBatch = session.getDataSource().getInfo().supportsBatchUpdates() && this.reuseStatement && !CommonUtils.toBoolean((Object)options.get("data.manipulate.disableBatches"));
        if (this.values.size() <= 1) {
            useBatch = false;
        }
        if (skipBindValues = CommonUtils.toBoolean((Object)options.get("data.manipulate.skipBindValues"))) {
            useBatch = false;
        }
        DBCStatistics statistics = new DBCStatistics();
        DBCStatement statement = null;
        try {
            boolean[] prevNulls = new boolean[this.attributes.length];
            boolean[] nulls = new boolean[this.attributes.length];
            int statementsInBatch = 0;
            for (int rowIndex = 0; rowIndex < this.values.size(); ++rowIndex) {
                boolean reuse;
                Object[] rowValues = this.values.get(rowIndex);
                if (session.getProgressMonitor().isCanceled()) break;
                if (rowIndex <= 0 || rowIndex % 100 == 0) {
                    // empty if block
                }
                boolean bl2 = reuse = !skipBindValues && this.reuseStatement;
                if (reuse) {
                    for (int i = 0; i < rowValues.length; ++i) {
                        nulls[i] = DBUtils.isNullValue(rowValues[i]);
                    }
                    if (!Arrays.equals(prevNulls, nulls) && statementsInBatch > 0) {
                        reuse = false;
                    }
                    System.arraycopy(nulls, 0, prevNulls, 0, nulls.length);
                    if (!reuse && statementsInBatch > 0) {
                        if (actions == null) {
                            this.flushBatch(statistics, statement);
                        }
                        DBUtils.closeSafely(statement);
                        statement = null;
                        statementsInBatch = 0;
                        reuse = true;
                    }
                }
                if (statement == null || !reuse) {
                    statement = this.prepareStatement(session, handlers, rowValues, options);
                    statistics.setQueryText(statement.getQueryString());
                    statistics.addStatementsCount();
                }
                try {
                    if (!skipBindValues) {
                        this.bindStatement(handlers, statement, rowValues);
                    }
                    if (actions == null) {
                        if (useBatch) {
                            statement.addToBatch();
                            ++statementsInBatch;
                            continue;
                        }
                        long startTime = System.currentTimeMillis();
                        this.executeStatement(statistics, statement);
                        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
                        long rowCount = statement.getUpdateRowCount();
                        if (rowCount > 0L) {
                            statistics.addRowsUpdated(rowCount);
                        }
                        if (this.keysReceiver == null) continue;
                        try {
                            this.readKeys(statement.getSession(), statement, this.keysReceiver);
                        }
                        catch (Exception e) {
                            log.warn("Error reading auto-generated keys", e);
                        }
                        continue;
                    }
                    String queryString = this.formatQueryParameters(session, statement.getQueryString(), handlers, rowValues);
                    actions.add(new SQLDatabasePersistAction("Execute statement", queryString));
                    continue;
                }
                finally {
                    if (!reuse && !useBatch) {
                        DBUtils.closeSafely(statement);
                    }
                }
            }
            if (statementsInBatch > 0) {
                if (actions == null) {
                    this.flushBatch(statistics, statement);
                }
                DBUtils.closeSafely(statement);
                statement = null;
            }
            this.values.clear();
        }
        finally {
            if (this.reuseStatement && statement != null) {
                DBUtils.closeSafely(statement);
            }
            if (!useBatch && !this.values.isEmpty()) {
                this.values.clear();
            }
        }
        return statistics;
    }

    protected int getNextUsedParamIndex(Object[] attributeValues, int paramIndex) {
        ++paramIndex;
        while (paramIndex < attributeValues.length && attributeValues[paramIndex] instanceof DBDNull) {
            ++paramIndex;
        }
        return paramIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    String formatQueryParameters(DBCSession session, String queryString, DBDValueHandler[] handlers, Object[] rowValues) {
        if (handlers.length == 0) {
            return queryString;
        }
        if (CommonUtils.isEmpty((String)queryString)) {
            return queryString;
        }
        int length = queryString.length();
        StringBuilder formatted = new StringBuilder(length * 2);
        int paramIndex = -1;
        int i = 0;
        while (true) {
            block13: {
                if (i >= length) {
                    return formatted.toString();
                }
                char c = queryString.charAt(i);
                block0 : switch (c) {
                    case '?': {
                        paramIndex = this.getNextUsedParamIndex(rowValues, paramIndex);
                        if (paramIndex >= handlers.length) {
                            log.error("Parameter index out of range (" + paramIndex + " > " + handlers.length + ")");
                            break block13;
                        } else {
                            String paramValue = SQLUtils.convertValueToSQL(session.getDataSource(), this.attributes[paramIndex], handlers[paramIndex], rowValues[paramIndex], DBDDisplayFormat.NATIVE, false);
                            formatted.append((Object)paramValue);
                        }
                        break block13;
                    }
                    case ':': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        formatted.append(c);
                        for (int k = i + 1; k < length; ++k) {
                            char c2 = queryString.charAt(k);
                            if (c2 == c && queryString.charAt(k - 1) != '\\') {
                                i = k;
                                c = c2;
                                break block0;
                            }
                            formatted.append(c2);
                        }
                    }
                }
                formatted.append(c);
            }
            ++i;
        }
    }

    void flushBatch(DBCStatistics statistics, DBCStatement statement) throws DBCException {
        long startTime = System.currentTimeMillis();
        long[] updatedRows = statement.executeStatementBatch();
        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
        if (!ArrayUtils.isEmpty((long[])updatedRows)) {
            for (long rows : updatedRows) {
                if (rows < 0L && !ArrayUtils.isEmpty((Object[])this.attributes)) {
                    rows = 1L;
                }
                statistics.addRowsUpdated(rows);
            }
        }
        this.saveExecuteWarnings(statistics, statement);
    }

    protected void executeStatement(DBCStatistics statistics, DBCStatement statement) throws DBCException {
        statement.executeStatement();
        this.saveExecuteWarnings(statistics, statement);
    }

    private void saveExecuteWarnings(DBCStatistics statistics, DBCStatement statement) throws DBCException {
        Throwable[] warnings = statement.getStatementWarnings();
        if (warnings != null) {
            for (Throwable w : warnings) {
                statistics.addWarning(w);
            }
        }
    }

    @Override
    public void close() {
    }

    private void readKeys(@NotNull DBCSession session, @NotNull DBCStatement dbStat, @NotNull DBDDataReceiver keysReceiver) throws DBException {
        DBCResultSet dbResult;
        try {
            dbResult = dbStat.openGeneratedKeysResultSet();
        }
        catch (Throwable e) {
            log.debug("Error obtaining generated keys", e);
            return;
        }
        if (dbResult == null) {
            return;
        }
        try (DBCResultSet dBCResultSet = dbResult;){
            DBDDataReceiver.startFetchWorkflow(keysReceiver, session, dbResult, -1L, -1L);
            while (dbResult.nextRow()) {
                keysReceiver.fetchRow(session, dbResult);
            }
        }
    }

    @NotNull
    protected abstract DBCStatement prepareStatement(@NotNull DBCSession var1, DBDValueHandler[] var2, Object[] var3, Map<String, Object> var4) throws DBCException;

    protected abstract void bindStatement(@NotNull DBDValueHandler[] var1, @NotNull DBCStatement var2, Object[] var3) throws DBCException;
}

