/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hsqldb.model.plan;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class HSQLExecutionPlan
extends AbstractExecutionPlan {
    private final String query;

    public HSQLExecutionPlan(@NotNull String query) {
        this.query = query;
    }

    public void explain(@NotNull DBCSession session) throws DBCException {
        JDBCSession connection = (JDBCSession)session;
        try (JDBCStatement stmt = connection.createStatement();){
            stmt.execute(this.getPlanQueryString());
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "EXPLAIN PLAN FOR " + this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return List.of();
    }
}

