/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.actions;

import org.eclipse.swt.widgets.Event;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintContext;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.actions.AbstractResultSetViewerAction;

public class HintConfigurationLevelAction
extends AbstractResultSetViewerAction {
    @NotNull
    private final DBDValueHintContext.HintConfigurationLevel configurationLevel;

    public HintConfigurationLevelAction(@NotNull ResultSetViewer resultSetViewer, @NotNull DBDValueHintContext.HintConfigurationLevel cl) {
        super(resultSetViewer, HintConfigurationLevelAction.getLevelTitle(resultSetViewer, cl), 8);
        this.configurationLevel = cl;
        this.setChecked(this.configurationLevel == this.getResultSetViewer().getHintContext().getConfigurationLevel());
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
    }

    public void runWithEvent(Event event) {
        if (this.isChecked()) {
            DBDValueHintContext hintContext = this.getResultSetViewer().getHintContext();
            hintContext.setConfigurationLevel(this.configurationLevel);
            this.getResultSetViewer().refreshData(null);
        }
    }

    private static String getLevelTitle(ResultSetViewer viewer, DBDValueHintContext.HintConfigurationLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case DBDValueHintContext.HintConfigurationLevel.GLOBAL -> "Global";
            case DBDValueHintContext.HintConfigurationLevel.DATASOURCE -> {
                DBPDataSource dataSource = viewer.getDataSource();
                if (dataSource == null) {
                    yield "N/A";
                }
                yield "Datasource (" + dataSource.getName() + ")";
            }
            case DBDValueHintContext.HintConfigurationLevel.ENTITY -> {
                DBSEntity singleSource = viewer.getModel().getSingleSource();
                if (singleSource == null) {
                    yield "N/A";
                }
                yield "Entity (" + DBUtils.getObjectFullName((DBPNamedObject)singleSource, (DBPEvaluationContext)DBPEvaluationContext.UI) + ")";
            }
        };
    }
}

