/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.FreeplaneGUIStarter;
import org.freeplane.main.application.UserReadmeWriter;

public class UserPropertiesUpdater {
    private static final String ORG_FREEPLANE_OLD_USERFPDIR = "org.freeplane.old_userfpdir";
    private final UserReadmeWriter userReadmeWriter = new UserReadmeWriter();

    FreeplaneGUIStarter.UserPropertiesStatus importOldProperties() {
        this.userReadmeWriter.ensureReadmeExists();
        File userPreferencesFile = ApplicationResourceController.getUserPreferencesFile();
        if (userPreferencesFile.exists()) {
            return FreeplaneGUIStarter.UserPropertiesStatus.CURRENT_VERSION_FOUND;
        }
        File previousPropertyDirectory = this.copyUserFilesFromPreviousVersionTo(userPreferencesFile.getParentFile());
        if (userPreferencesFile.exists()) {
            try {
                Properties userProp = this.loadProperties(userPreferencesFile);
                if (!FreeplaneVersion.getVersion().isFinal()) {
                    for (String name : Arrays.asList("lastOpened_1.0.20", "openedNow_1.3.04")) {
                        userProp.remove(name);
                    }
                }
                String value = userProp.getProperty("single_backup_directory_path");
                String previousPropertyDirectoryPath = previousPropertyDirectory.getPath();
                if (value != null && value.startsWith(previousPropertyDirectoryPath)) {
                    value = "{freeplaneuserdir}" + value.substring(previousPropertyDirectoryPath.length());
                    userProp.setProperty("single_backup_directory_path", value);
                }
                this.saveProperties(userProp, userPreferencesFile);
                return FreeplaneGUIStarter.UserPropertiesStatus.OLD_VERSION_FOUND;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FreeplaneGUIStarter.UserPropertiesStatus.NOT_FOUND;
    }

    private File copyUserFilesFromPreviousVersionTo(File targetDirectory) {
        try {
            File canonicalTargetDirectory = targetDirectory.getCanonicalFile();
            File parentDirectory = canonicalTargetDirectory.getParentFile();
            String previousDirName = "1.11.x";
            String old_userfpdir = System.getProperty(ORG_FREEPLANE_OLD_USERFPDIR);
            File previousPropertyDirectory = this.isDefined(old_userfpdir) ? new File(old_userfpdir, "1.11.x").getCanonicalFile() : new File(parentDirectory, "1.11.x").getCanonicalFile();
            if (previousPropertyDirectory.exists() && !previousPropertyDirectory.equals(canonicalTargetDirectory)) {
                parentDirectory.mkdirs();
                FileUtils.copyDirectory((File)previousPropertyDirectory, (File)canonicalTargetDirectory, file -> !Stream.of("logs", ".backup", "compiledscripts", "compiledscripts2").map(name -> new File(previousPropertyDirectory, (String)name)).anyMatch(file::equals), (boolean)true);
                new File(canonicalTargetDirectory, "templates").mkdir();
            }
            return previousPropertyDirectory;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isDefined(String old_userfpdir) {
        return old_userfpdir != null;
    }

    Properties loadProperties(File userPreferencesFile) throws IOException {
        Properties userProp = new Properties();
        try (FileInputStream inputStream = new FileInputStream(userPreferencesFile);){
            userProp.load(inputStream);
        }
        return userProp;
    }

    void saveProperties(Properties userProp, File userPreferencesFile) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(userPreferencesFile);){
            userProp.store(outputStream, null);
        }
    }
}

