/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.code.ExecutionStack;
import com.android.dx.cf.code.OneLocalsArray;
import com.android.dx.cf.code.SimException;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.util.Hex;
import com.android.dx.util.MutabilityControl;

public final class Merger {
    private Merger() {
    }

    public static OneLocalsArray mergeLocals(OneLocalsArray locals1, OneLocalsArray locals2) {
        if (locals1 == locals2) {
            return locals1;
        }
        int sz4 = locals1.getMaxLocals();
        MutabilityControl result = null;
        if (locals2.getMaxLocals() != sz4) {
            throw new SimException("mismatched maxLocals values");
        }
        for (int i15 = 0; i15 < sz4; ++i15) {
            TypeBearer tb22;
            TypeBearer tb12 = locals1.getOrNull(i15);
            TypeBearer resultType = Merger.mergeType(tb12, tb22 = locals2.getOrNull(i15));
            if (resultType == tb12) continue;
            if (result == null) {
                result = locals1.copy();
            }
            if (resultType == null) {
                ((OneLocalsArray)result).invalidate(i15);
                continue;
            }
            ((OneLocalsArray)result).set(i15, resultType);
        }
        if (result == null) {
            return locals1;
        }
        result.setImmutable();
        return result;
    }

    public static ExecutionStack mergeStack(ExecutionStack stack1, ExecutionStack stack2) {
        if (stack1 == stack2) {
            return stack1;
        }
        int sz4 = stack1.size();
        MutabilityControl result = null;
        if (stack2.size() != sz4) {
            throw new SimException("mismatched stack depths");
        }
        for (int i15 = 0; i15 < sz4; ++i15) {
            TypeBearer tb22;
            TypeBearer tb12 = stack1.peek(i15);
            TypeBearer resultType = Merger.mergeType(tb12, tb22 = stack2.peek(i15));
            if (resultType == tb12) continue;
            if (result == null) {
                result = stack1.copy();
            }
            try {
                if (resultType == null) {
                    throw new SimException("incompatible: " + tb12 + ", " + tb22);
                }
                ((ExecutionStack)result).change(i15, resultType);
                continue;
            }
            catch (SimException ex4) {
                ex4.addContext("...while merging stack[" + Hex.u2(i15) + "]");
                throw ex4;
            }
        }
        if (result == null) {
            return stack1;
        }
        result.setImmutable();
        return result;
    }

    public static TypeBearer mergeType(TypeBearer ft12, TypeBearer ft22) {
        Type type2;
        if (ft12 == null || ft12.equals(ft22)) {
            return ft12;
        }
        if (ft22 == null) {
            return null;
        }
        Type type1 = ft12.getType();
        if (type1 == (type2 = ft22.getType())) {
            return type1;
        }
        if (type1.isReference() && type2.isReference()) {
            if (type1 == Type.KNOWN_NULL) {
                return type2;
            }
            if (type2 == Type.KNOWN_NULL) {
                return type1;
            }
            if (type1.isArray() && type2.isArray()) {
                TypeBearer componentUnion = Merger.mergeType(type1.getComponentType(), type2.getComponentType());
                if (componentUnion == null) {
                    return Type.OBJECT;
                }
                return ((Type)componentUnion).getArrayType();
            }
            return Type.OBJECT;
        }
        if (type1.isIntlike() && type2.isIntlike()) {
            return Type.INT;
        }
        return null;
    }

    public static boolean isPossiblyAssignableFrom(TypeBearer supertypeBearer, TypeBearer subtypeBearer) {
        Type subtype;
        Type supertype = supertypeBearer.getType();
        if (supertype.equals(subtype = subtypeBearer.getType())) {
            return true;
        }
        int superBt = supertype.getBasicType();
        int subBt = subtype.getBasicType();
        if (superBt == 10) {
            supertype = Type.OBJECT;
            superBt = 9;
        }
        if (subBt == 10) {
            subtype = Type.OBJECT;
            subBt = 9;
        }
        if (superBt != 9 || subBt != 9) {
            return supertype.isIntlike() && subtype.isIntlike();
        }
        if (supertype == Type.KNOWN_NULL) {
            return false;
        }
        if (subtype == Type.KNOWN_NULL) {
            return true;
        }
        if (supertype == Type.OBJECT) {
            return true;
        }
        if (supertype.isArray()) {
            if (!subtype.isArray()) {
                return false;
            }
            do {
                supertype = supertype.getComponentType();
                subtype = subtype.getComponentType();
            } while (supertype.isArray() && subtype.isArray());
            return Merger.isPossiblyAssignableFrom(supertype, subtype);
        }
        if (subtype.isArray()) {
            return supertype == Type.SERIALIZABLE || supertype == Type.CLONEABLE;
        }
        return true;
    }
}

