/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorUtil {
    private static final int[][] SRGBtoLinearRGBPre = new int[256][256];
    private static final int[] SRGBtoLinearRGB = new int[256];
    private static final int[][] LinearRGBtoSRGBPre = new int[256][256];
    private static final int[] LinearRGBtoSRGB = new int[256];

    private ColorUtil() {
    }

    public static int div255(int x15) {
        return (x15 += 128) + (x15 >> 8) >> 8;
    }

    public static int computeLuminance(int r15, int g15, int b15) {
        return ColorUtil.toRgbRange(0.2125 * (double)r15 + 0.7164 * (double)g15 + 0.0712 * (double)b15);
    }

    public static int toRgbRange(double value) {
        return (int)Math.max(Math.min(Math.round(value), 255L), 0L);
    }

    public static Color withAlpha(@NotNull Color c15, float alpha) {
        int a15 = Math.max(Math.min(255, (int)(alpha * 255.0f)), 0);
        return new Color(c15.getRed(), c15.getGreen(), c15.getBlue(), a15);
    }

    public static String toString(@Nullable Color c15) {
        if (c15 == null) {
            return "null";
        }
        return String.format("Color[%d,%d,%d,%d]", c15.getRed(), c15.getGreen(), c15.getBlue(), c15.getAlpha());
    }

    public static void RGBPretoHSL(int r15, int g15, int b15, int a15, float @NotNull [] hsl) {
        float s15;
        float h15;
        float maxComponent;
        float minComponent;
        if (r15 < 0) {
            r15 = 0;
        } else if (r15 > 255) {
            r15 = 255;
        }
        if (g15 < 0) {
            g15 = 0;
        } else if (g15 > 255) {
            g15 = 255;
        }
        if (b15 < 0) {
            b15 = 0;
        } else if (b15 > 255) {
            b15 = 255;
        }
        float componentR = (float)r15 / (float)a15;
        float componentG = (float)g15 / (float)a15;
        float componentB = (float)b15 / (float)a15;
        if (componentR > componentG) {
            minComponent = componentG;
            maxComponent = componentR;
        } else {
            minComponent = componentR;
            maxComponent = componentG;
        }
        if (componentB > maxComponent) {
            maxComponent = componentB;
        }
        if (componentB < minComponent) {
            minComponent = componentB;
        }
        float deltaMax = maxComponent - minComponent;
        float l15 = (maxComponent + minComponent) / 2.0f;
        if (deltaMax - 0.01f <= 0.0f) {
            h15 = 0.0f;
            s15 = 0.0f;
        } else {
            if (l15 < 0.5f) {
                assert (maxComponent + minComponent != 0.0f);
                s15 = deltaMax / (maxComponent + minComponent);
            } else {
                s15 = deltaMax / (2.0f - maxComponent - minComponent);
            }
            assert (deltaMax > 0.0f);
            float deltaR = ((maxComponent - componentR) / 6.0f + deltaMax / 2.0f) / deltaMax;
            float deltaG = ((maxComponent - componentG) / 6.0f + deltaMax / 2.0f) / deltaMax;
            float deltaB = ((maxComponent - componentB) / 6.0f + deltaMax / 2.0f) / deltaMax;
            h15 = componentR == maxComponent ? deltaB - deltaG : (componentG == maxComponent ? 0.33333334f + deltaR - deltaB : 0.6666667f + deltaG - deltaR);
            if (h15 < 0.0f) {
                h15 += 1.0f;
            }
            if (h15 > 1.0f) {
                h15 -= 1.0f;
            }
        }
        hsl[0] = h15;
        hsl[1] = s15;
        hsl[2] = l15;
    }

    public static void HSLtoRGB(float h15, float s15, float l15, int @NotNull [] rgb) {
        int b15;
        int g15;
        int r15;
        if (h15 < 0.0f) {
            h15 = 0.0f;
        } else if (h15 > 1.0f) {
            h15 = 1.0f;
        }
        if (s15 < 0.0f) {
            s15 = 0.0f;
        } else if (s15 > 1.0f) {
            s15 = 1.0f;
        }
        if (l15 < 0.0f) {
            l15 = 0.0f;
        } else if (l15 > 1.0f) {
            l15 = 1.0f;
        }
        if (s15 - 0.01f <= 0.0f) {
            r15 = (int)(l15 * 255.0f);
            g15 = (int)(l15 * 255.0f);
            b15 = (int)(l15 * 255.0f);
        } else {
            float y15 = l15 < 0.5f ? l15 * (1.0f + s15) : l15 + s15 - s15 * l15;
            float x15 = 2.0f * l15 - y15;
            r15 = (int)(255.0f * ColorUtil.hue2RGB(x15, y15, h15 + 0.33333334f));
            g15 = (int)(255.0f * ColorUtil.hue2RGB(x15, y15, h15));
            b15 = (int)(255.0f * ColorUtil.hue2RGB(x15, y15, h15 - 0.33333334f));
        }
        rgb[0] = r15;
        rgb[1] = g15;
        rgb[2] = b15;
    }

    private static float hue2RGB(float v15, float v25, float vH2) {
        if (vH2 < 0.0f) {
            vH2 += 1.0f;
        }
        if (vH2 > 1.0f) {
            vH2 -= 1.0f;
        }
        if (6.0f * vH2 < 1.0f) {
            return v15 + (v25 - v15) * 6.0f * vH2;
        }
        if (2.0f * vH2 < 1.0f) {
            return v25;
        }
        if (3.0f * vH2 < 2.0f) {
            return v15 + (v25 - v15) * (0.6666667f - vH2) * 6.0f;
        }
        return v15;
    }

    public static void sRGBtoLinearRGBinPlace(int @NotNull [] argb) {
        argb[0] = SRGBtoLinearRGB[argb[0]];
        argb[1] = SRGBtoLinearRGB[argb[1]];
        argb[2] = SRGBtoLinearRGB[argb[2]];
    }

    public static void linearRGBtoSRGBinPlace(int @NotNull [] argb) {
        argb[0] = LinearRGBtoSRGB[argb[0]];
        argb[1] = LinearRGBtoSRGB[argb[1]];
        argb[2] = LinearRGBtoSRGB[argb[2]];
    }

    public static void sRGBtoLinearRGBPreInPlace(int @NotNull [] argb) {
        int alpha = argb[3];
        int[] table = SRGBtoLinearRGBPre[alpha];
        argb[0] = table[argb[0]];
        argb[1] = table[argb[1]];
        argb[2] = table[argb[2]];
    }

    public static void linearRGBtoSRGBPreInPlace(int @NotNull [] argb) {
        int alpha = argb[3];
        int[] table = LinearRGBtoSRGBPre[alpha];
        argb[0] = table[argb[0]];
        argb[1] = table[argb[1]];
        argb[2] = table[argb[2]];
    }

    public static int sRGBtoLinearRGBBand(int value) {
        return SRGBtoLinearRGB[value];
    }

    public static int sRGBtoLinearRGB(int argb) {
        int a15 = argb >>> 24;
        int r15 = SRGBtoLinearRGB[argb >> 16 & 0xFF];
        int g15 = SRGBtoLinearRGB[argb >> 8 & 0xFF];
        int b15 = SRGBtoLinearRGB[argb & 0xFF];
        return (a15 & 0xFF) << 24 | (r15 & 0xFF) << 16 | (g15 & 0xFF) << 8 | b15 & 0xFF;
    }

    public static int linearRGBtoSRGBBand(int value) {
        return LinearRGBtoSRGB[value];
    }

    public static int linearRGBtoSRGB(int argb) {
        int a15 = argb >>> 24;
        int r15 = LinearRGBtoSRGB[argb >> 16 & 0xFF];
        int g15 = LinearRGBtoSRGB[argb >> 8 & 0xFF];
        int b15 = LinearRGBtoSRGB[argb & 0xFF];
        return (a15 & 0xFF) << 24 | (r15 & 0xFF) << 16 | (g15 & 0xFF) << 8 | b15 & 0xFF;
    }

    private static int convertSRGBtoLinearRGB(int color, float alpha) {
        float factor = 255.0f * alpha;
        float input = (float)color / factor;
        float output = input <= 0.04045f ? input / 12.92f : (float)Math.pow(((double)input + 0.055) / 1.055, 2.4);
        return Math.round(output * factor);
    }

    private static int convertLinearRGBtoSRGB(int color, float alpha) {
        float factor = 255.0f * alpha;
        float input = (float)color / factor;
        float output = (double)input <= 0.0031308 ? input * 12.92f : 1.055f * (float)Math.pow(input, 0.4166666666666667) - 0.055f;
        return Math.round(output * factor);
    }

    public static int clampColor(int v15) {
        return Math.max(Math.min(255, v15), 0);
    }

    static {
        for (int k15 = 0; k15 < 256; ++k15) {
            ColorUtil.SRGBtoLinearRGB[k15] = ColorUtil.convertSRGBtoLinearRGB(k15, 1.0f);
            ColorUtil.LinearRGBtoSRGB[k15] = ColorUtil.convertLinearRGBtoSRGB(k15, 1.0f);
        }
        ColorUtil.SRGBtoLinearRGBPre[255] = SRGBtoLinearRGB;
        ColorUtil.LinearRGBtoSRGBPre[255] = LinearRGBtoSRGB;
        for (int i15 = 0; i15 < 255; ++i15) {
            int[] sRGBtoLinear = new int[256];
            int[] linearTosRGB = new int[256];
            float alpha = (float)i15 / 255.0f;
            for (int k16 = 0; k16 < 256; ++k16) {
                sRGBtoLinear[k16] = ColorUtil.convertSRGBtoLinearRGB(k16, alpha);
                linearTosRGB[k16] = ColorUtil.convertLinearRGBtoSRGB(k16, alpha);
            }
            ColorUtil.SRGBtoLinearRGBPre[i15] = sRGBtoLinear;
            ColorUtil.LinearRGBtoSRGBPre[i15] = linearTosRGB;
        }
    }
}

