/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.tiff;

public final class Half
extends Number
implements Comparable<Half> {
    public static final int SIZE = 16;
    private final short shortBits;
    private final transient float floatValue;

    public Half(short s15) {
        this.shortBits = s15;
        this.floatValue = Half.shortBitsToFloat(s15);
    }

    @Override
    public int intValue() {
        return (int)this.floatValue;
    }

    @Override
    public long longValue() {
        return (long)this.floatValue;
    }

    @Override
    public float floatValue() {
        return this.floatValue;
    }

    @Override
    public double doubleValue() {
        return this.floatValue;
    }

    public int hashCode() {
        return this.shortBits;
    }

    public boolean equals(Object object) {
        return object instanceof Half && ((Half)object).shortBits == this.shortBits;
    }

    @Override
    public int compareTo(Half half) {
        return Float.compare(this.floatValue, half.floatValue);
    }

    public String toString() {
        return Float.toString(this.floatValue);
    }

    public static Half valueOf(String string) throws NumberFormatException {
        return new Half(Half.parseHalf(string));
    }

    public static short parseHalf(String string) throws NumberFormatException {
        return Half.floatToShortBits(Float.parseFloat(string));
    }

    public static float shortBitsToFloat(short s15) {
        int n15 = s15 & 0x3FF;
        int n16 = s15 & 0x7C00;
        if (n16 == 31744) {
            n16 = 261120;
        } else if (n16 != 0) {
            n16 += 114688;
        } else if (n15 != 0) {
            n16 = 115712;
            do {
                n16 -= 1024;
            } while (((n15 <<= 1) & 0x400) == 0);
            n15 &= 0x3FF;
        }
        return Float.intBitsToFloat((s15 & 0x8000) << 16 | (n16 | n15) << 13);
    }

    public static short floatToShortBits(float f15) {
        return (short)Half.floatTo16Bits(f15);
    }

    private static int floatTo16Bits(float f15) {
        int n15 = Float.floatToIntBits(f15);
        int n16 = n15 >>> 16 & 0x8000;
        int n17 = (n15 & Integer.MAX_VALUE) + 4096;
        if (n17 >= 1199570944) {
            if ((n15 & Integer.MAX_VALUE) >= 1199570944) {
                if (n17 < 2139095040) {
                    return n16 | 0x7C00;
                }
                return n16 | 0x7C00 | (n15 & 0x7FFFFF) >>> 13;
            }
            return n16 | 0x7BFF;
        }
        if (n17 >= 0x38800000) {
            return n16 | n17 - 0x38000000 >>> 13;
        }
        if (n17 < 0x33000000) {
            return n16;
        }
        n17 = (n15 & Integer.MAX_VALUE) >>> 23;
        return n16 | (n15 & 0x7FFFFF | 0x800000) + (0x800000 >>> n17 - 102) >>> 126 - n17;
    }

    private Object readResolve() {
        return new Half(this.shortBits);
    }
}

