/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.vp8;

import com.twelvemonkeys.imageio.plugins.webp.vp8.BoolDecoder;
import com.twelvemonkeys.imageio.plugins.webp.vp8.Globals;
import com.twelvemonkeys.imageio.plugins.webp.vp8.IDCT;
import com.twelvemonkeys.imageio.plugins.webp.vp8.MacroBlock;
import com.twelvemonkeys.imageio.plugins.webp.vp8.VP8Frame;
import java.io.IOException;

final class SubBlock {
    private final SubBlock above;
    private int[][] dest;
    private int[][] diff;
    private boolean hasNoZeroToken;
    private final SubBlock left;
    private final MacroBlock macroBlock;
    private int mode;
    private final Plane plane;
    private int[][] predict;
    private int[] tokens = new int[16];

    SubBlock(MacroBlock macroBlock, SubBlock subBlock, SubBlock subBlock2, Plane plane) {
        this.macroBlock = macroBlock;
        this.plane = plane;
        this.above = subBlock;
        this.left = subBlock2;
        this.mode = 0;
        for (int i15 = 0; i15 < 16; ++i15) {
            this.tokens[i15] = 0;
        }
    }

    public static int planeToType(Plane plane, boolean bl4) {
        switch (plane) {
            case Y2: {
                return 1;
            }
            case Y1: {
                return bl4 ? 0 : 3;
            }
            case U: 
            case V: {
                return 2;
            }
        }
        return -1;
    }

    private int DCTextra(BoolDecoder boolDecoder, int[] nArray) throws IOException {
        int n15 = 0;
        int n16 = 0;
        do {
            n15 += n15 + boolDecoder.readBool(nArray[n16]);
        } while (nArray[++n16] > 0);
        return n15;
    }

    public void decodeSubBlock(BoolDecoder boolDecoder, int[][][][] nArray, int n15, int n16, boolean bl4) throws IOException {
        int n17;
        SubBlock subBlock = this;
        int n18 = 0;
        if (bl4) {
            n18 = 1;
        }
        int n19 = n15;
        int n25 = 0;
        int n26 = 1;
        boolean bl5 = false;
        while (n26 != 11 && n25 + n18 < 16) {
            n26 = boolDecoder.readTree(Globals.vp8CoefTree, nArray[n16][Globals.vp8CoefBands[n25 + n18]][n19], bl5 ? 1 : 0);
            n17 = this.decodeToken(boolDecoder, n26);
            n19 = 0;
            bl5 = false;
            if (n17 == 1 || n17 == -1) {
                n19 = 1;
            } else if (n17 > 1 || n17 < -1) {
                n19 = 2;
            } else if (n17 == 0) {
                bl5 = true;
            }
            int[] nArray2 = subBlock.getTokens();
            if (n26 != 11) {
                nArray2[Globals.vp8defaultZigZag1d[n25 + n18]] = n17;
            }
            ++n25;
        }
        this.hasNoZeroToken = false;
        for (n17 = 0; n17 < 16; ++n17) {
            if (this.tokens[n17] == 0) continue;
            this.hasNoZeroToken = true;
        }
    }

    private int decodeToken(BoolDecoder boolDecoder, int n15) throws IOException {
        int n16 = n15;
        if (n15 == 5) {
            n16 = 5 + this.DCTextra(boolDecoder, Globals.Pcat1);
        }
        if (n15 == 6) {
            n16 = 7 + this.DCTextra(boolDecoder, Globals.Pcat2);
        }
        if (n15 == 7) {
            n16 = 11 + this.DCTextra(boolDecoder, Globals.Pcat3);
        }
        if (n15 == 8) {
            n16 = 19 + this.DCTextra(boolDecoder, Globals.Pcat4);
        }
        if (n15 == 9) {
            n16 = 35 + this.DCTextra(boolDecoder, Globals.Pcat5);
        }
        if (n15 == 10) {
            n16 = 67 + this.DCTextra(boolDecoder, Globals.Pcat6);
        }
        if (n15 != 0 && n15 != 11 && boolDecoder.readBit() > 0) {
            n16 = -n16;
        }
        return n16;
    }

    public void dequantSubBlock(VP8Frame vP8Frame, Integer n15) {
        SubBlock subBlock = this;
        int[] nArray = new int[16];
        for (int i15 = 0; i15 < 16; ++i15) {
            int n16;
            if (this.plane == Plane.U || this.plane == Plane.V) {
                n16 = vP8Frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getUvac_delta_q();
                if (i15 == 0) {
                    n16 = vP8Frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getUvdc_delta_q();
                }
            } else {
                n16 = vP8Frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getY1ac();
                if (i15 == 0) {
                    n16 = vP8Frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getY1dc();
                }
            }
            int n17 = subBlock.getTokens()[i15];
            nArray[i15] = n17 * n16;
        }
        if (n15 != null) {
            nArray[0] = n15;
        }
        int[][] nArray2 = IDCT.idct4x4llm(nArray);
        subBlock.setDiff(nArray2);
    }

    public void drawDebug() {
        if (this.dest != null) {
            this.dest[0][0] = 128;
            this.dest[1][0] = 128;
            this.dest[2][0] = 128;
            this.dest[3][0] = 128;
            this.dest[0][0] = 128;
            this.dest[0][1] = 128;
            this.dest[0][2] = 128;
            this.dest[0][3] = 128;
        }
    }

    public void drawDebugH() {
        if (this.dest != null) {
            this.dest[0][0] = 0;
            this.dest[1][0] = 0;
            this.dest[2][0] = 0;
            this.dest[3][0] = 0;
        }
    }

    public void drawDebugV() {
        if (this.dest != null) {
            this.dest[0][0] = 0;
            this.dest[0][1] = 0;
            this.dest[0][2] = 0;
            this.dest[0][3] = 0;
        }
    }

    public SubBlock getAbove() {
        return this.above;
    }

    public String getDebugString() {
        String string = "";
        string = string + "  " + (Object)((Object)this.plane);
        if (this.getMacroBlock().getYMode() == 4 && this.plane == Plane.Y1) {
            string = string + "\n  " + Globals.getSubBlockModeAsString(this.mode);
        }
        return string;
    }

    public int[][] getDest() {
        if (this.dest != null) {
            return this.dest;
        }
        return new int[4][4];
    }

    public int[][] getDiff() {
        return this.diff;
    }

    public SubBlock getLeft() {
        return this.left;
    }

    public MacroBlock getMacroBlock() {
        return this.macroBlock;
    }

    public int[][] getMacroBlockPredict(int n15) {
        if (this.dest != null) {
            return this.dest;
        }
        int n16 = 127;
        if (n15 == 2) {
            n16 = 129;
        }
        int[][] nArray = new int[4][4];
        for (int i15 = 0; i15 < 4; ++i15) {
            for (int i16 = 0; i16 < 4; ++i16) {
                nArray[i16][i15] = n16;
            }
        }
        return nArray;
    }

    public int getMode() {
        return this.mode;
    }

    public Plane getPlane() {
        return this.plane;
    }

    public int[][] getPredict() {
        if (this.predict != null) {
            return this.predict;
        }
        return this.getPredict(0, false);
    }

    public int[][] getPredict(int n15, boolean bl4) {
        if (this.dest != null) {
            return this.dest;
        }
        if (this.predict != null) {
            return this.predict;
        }
        int n16 = 127;
        if ((n15 == 1 || n15 == 0 || n15 == 2 || n15 == 3 || n15 == 6 || n15 == 5 || n15 == 8) && bl4) {
            n16 = 129;
        }
        int[][] nArray = new int[4][4];
        for (int i15 = 0; i15 < 4; ++i15) {
            for (int i16 = 0; i16 < 4; ++i16) {
                nArray[i16][i15] = n16;
            }
        }
        return nArray;
    }

    int[] getTokens() {
        return this.tokens;
    }

    public boolean hasNoZeroToken() {
        return this.hasNoZeroToken;
    }

    public boolean isDest() {
        return this.dest != null;
    }

    public void predict(VP8Frame vP8Frame) {
        SubBlock subBlock = this;
        SubBlock subBlock2 = vP8Frame.getAboveSubBlock(subBlock, subBlock.getPlane());
        SubBlock subBlock3 = vP8Frame.getLeftSubBlock(subBlock, subBlock.getPlane());
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = subBlock2.getPredict(subBlock.getMode(), false)[0][3];
        nArray[1] = subBlock2.getPredict(subBlock.getMode(), false)[1][3];
        nArray[2] = subBlock2.getPredict(subBlock.getMode(), false)[2][3];
        nArray[3] = subBlock2.getPredict(subBlock.getMode(), false)[3][3];
        nArray2[0] = subBlock3.getPredict(subBlock.getMode(), true)[3][0];
        nArray2[1] = subBlock3.getPredict(subBlock.getMode(), true)[3][1];
        nArray2[2] = subBlock3.getPredict(subBlock.getMode(), true)[3][2];
        nArray2[3] = subBlock3.getPredict(subBlock.getMode(), true)[3][3];
        SubBlock subBlock4 = vP8Frame.getLeftSubBlock(subBlock2, subBlock.getPlane());
        int n15 = !subBlock3.isDest() && !subBlock2.isDest() ? subBlock4.getPredict(subBlock.getMode(), false)[3][3] : (!subBlock2.isDest() ? subBlock4.getPredict(subBlock.getMode(), false)[3][3] : subBlock4.getPredict(subBlock.getMode(), true)[3][3]);
        SubBlock subBlock5 = vP8Frame.getAboveRightSubBlock(subBlock, subBlock.plane);
        int[] nArray3 = new int[]{subBlock5.getPredict(subBlock.getMode(), false)[0][3], subBlock5.getPredict(subBlock.getMode(), false)[1][3], subBlock5.getPredict(subBlock.getMode(), false)[2][3], subBlock5.getPredict(subBlock.getMode(), false)[3][3]};
        int[][] nArray4 = new int[4][4];
        switch (subBlock.getMode()) {
            case 0: {
                int n16;
                int n17 = 0;
                for (n16 = 0; n16 < 4; ++n16) {
                    n17 += nArray[n16];
                    n17 += nArray2[n16];
                }
                n17 = n17 + 4 >> 3;
                for (n16 = 0; n16 < 4; ++n16) {
                    for (int i15 = 0; i15 < 4; ++i15) {
                        nArray4[i15][n16] = n17;
                    }
                }
                break;
            }
            case 1: {
                for (int i16 = 0; i16 < 4; ++i16) {
                    for (int i17 = 0; i17 < 4; ++i17) {
                        int n18 = nArray[i17] - n15 + nArray2[i16];
                        if (n18 < 0) {
                            n18 = 0;
                        }
                        if (n18 > 255) {
                            n18 = 255;
                        }
                        nArray4[i17][i16] = n18;
                    }
                }
                break;
            }
            case 2: {
                int[] nArray5 = new int[]{n15 + 2 * nArray[0] + nArray[1] + 2 >> 2, nArray[0] + 2 * nArray[1] + nArray[2] + 2 >> 2, nArray[1] + 2 * nArray[2] + nArray[3] + 2 >> 2, nArray[2] + 2 * nArray[3] + nArray3[0] + 2 >> 2};
                for (int i18 = 0; i18 < 4; ++i18) {
                    for (int i19 = 0; i19 < 4; ++i19) {
                        nArray4[i19][i18] = nArray5[i19];
                    }
                }
                break;
            }
            case 3: {
                int[] nArray6 = new int[]{n15 + 2 * nArray2[0] + nArray2[1] + 2 >> 2, nArray2[0] + 2 * nArray2[1] + nArray2[2] + 2 >> 2, nArray2[1] + 2 * nArray2[2] + nArray2[3] + 2 >> 2, nArray2[2] + 2 * nArray2[3] + nArray2[3] + 2 >> 2};
                for (int i25 = 0; i25 < 4; ++i25) {
                    for (int i26 = 0; i26 < 4; ++i26) {
                        nArray4[i26][i25] = nArray6[i25];
                    }
                }
                break;
            }
            case 4: {
                nArray4[0][0] = nArray[0] + nArray[1] * 2 + nArray[2] + 2 >> 2;
                int n19 = nArray[1] + nArray[2] * 2 + nArray[3] + 2 >> 2;
                nArray4[0][1] = n19;
                nArray4[1][0] = n19;
                int n25 = nArray[2] + nArray[3] * 2 + nArray3[0] + 2 >> 2;
                nArray4[0][2] = n25;
                nArray4[1][1] = n25;
                nArray4[2][0] = n25;
                int n26 = nArray[3] + nArray3[0] * 2 + nArray3[1] + 2 >> 2;
                nArray4[0][3] = n26;
                nArray4[1][2] = n26;
                nArray4[2][1] = n26;
                nArray4[3][0] = n26;
                int n27 = nArray3[0] + nArray3[1] * 2 + nArray3[2] + 2 >> 2;
                nArray4[1][3] = n27;
                nArray4[2][2] = n27;
                nArray4[3][1] = n27;
                int n28 = nArray3[1] + nArray3[2] * 2 + nArray3[3] + 2 >> 2;
                nArray4[2][3] = n28;
                nArray4[3][2] = n28;
                nArray4[3][3] = nArray3[2] + nArray3[3] * 2 + nArray3[3] + 2 >> 2;
                break;
            }
            case 5: {
                int[] nArray7 = new int[]{nArray2[3], nArray2[2], nArray2[1], nArray2[0], n15, nArray[0], nArray[1], nArray[2], nArray[3]};
                nArray4[0][3] = nArray7[0] + nArray7[1] * 2 + nArray7[2] + 2 >> 2;
                int n29 = nArray7[1] + nArray7[2] * 2 + nArray7[3] + 2 >> 2;
                nArray4[0][2] = n29;
                nArray4[1][3] = n29;
                int n35 = nArray7[2] + nArray7[3] * 2 + nArray7[4] + 2 >> 2;
                nArray4[0][1] = n35;
                nArray4[1][2] = n35;
                nArray4[2][3] = n35;
                int n36 = nArray7[3] + nArray7[4] * 2 + nArray7[5] + 2 >> 2;
                nArray4[0][0] = n36;
                nArray4[1][1] = n36;
                nArray4[2][2] = n36;
                nArray4[3][3] = n36;
                int n37 = nArray7[4] + nArray7[5] * 2 + nArray7[6] + 2 >> 2;
                nArray4[1][0] = n37;
                nArray4[2][1] = n37;
                nArray4[3][2] = n37;
                int n38 = nArray7[5] + nArray7[6] * 2 + nArray7[7] + 2 >> 2;
                nArray4[2][0] = n38;
                nArray4[3][1] = n38;
                nArray4[3][0] = nArray7[6] + nArray7[7] * 2 + nArray7[8] + 2 >> 2;
                break;
            }
            case 6: {
                int[] nArray8 = new int[]{nArray2[3], nArray2[2], nArray2[1], nArray2[0], n15, nArray[0], nArray[1], nArray[2], nArray[3]};
                nArray4[0][3] = nArray8[1] + nArray8[2] * 2 + nArray8[3] + 2 >> 2;
                nArray4[0][2] = nArray8[2] + nArray8[3] * 2 + nArray8[4] + 2 >> 2;
                int n39 = nArray8[3] + nArray8[4] * 2 + nArray8[5] + 2 >> 2;
                nArray4[0][1] = n39;
                nArray4[1][3] = n39;
                int n45 = nArray8[4] + nArray8[5] + 1 >> 1;
                nArray4[0][0] = n45;
                nArray4[1][2] = n45;
                int n46 = nArray8[4] + nArray8[5] * 2 + nArray8[6] + 2 >> 2;
                nArray4[1][1] = n46;
                nArray4[2][3] = n46;
                int n47 = nArray8[5] + nArray8[6] + 1 >> 1;
                nArray4[1][0] = n47;
                nArray4[2][2] = n47;
                int n48 = nArray8[5] + nArray8[6] * 2 + nArray8[7] + 2 >> 2;
                nArray4[2][1] = n48;
                nArray4[3][3] = n48;
                int n49 = nArray8[6] + nArray8[7] + 1 >> 1;
                nArray4[2][0] = n49;
                nArray4[3][2] = n49;
                nArray4[3][1] = nArray8[6] + nArray8[7] * 2 + nArray8[8] + 2 >> 2;
                nArray4[3][0] = nArray8[7] + nArray8[8] + 1 >> 1;
                break;
            }
            case 7: {
                nArray4[0][0] = nArray[0] + nArray[1] + 1 >> 1;
                nArray4[0][1] = nArray[0] + nArray[1] * 2 + nArray[2] + 2 >> 2;
                int n55 = nArray[1] + nArray[2] + 1 >> 1;
                nArray4[1][0] = n55;
                nArray4[0][2] = n55;
                int n56 = nArray[1] + nArray[2] * 2 + nArray[3] + 2 >> 2;
                nArray4[0][3] = n56;
                nArray4[1][1] = n56;
                int n57 = nArray[2] + nArray[3] + 1 >> 1;
                nArray4[2][0] = n57;
                nArray4[1][2] = n57;
                int n58 = nArray[2] + nArray[3] * 2 + nArray3[0] + 2 >> 2;
                nArray4[2][1] = n58;
                nArray4[1][3] = n58;
                int n59 = nArray[3] + nArray3[0] + 1 >> 1;
                nArray4[2][2] = n59;
                nArray4[3][0] = n59;
                int n65 = nArray[3] + nArray3[0] * 2 + nArray3[1] + 2 >> 2;
                nArray4[2][3] = n65;
                nArray4[3][1] = n65;
                nArray4[3][2] = nArray3[0] + nArray3[1] * 2 + nArray3[2] + 2 >> 2;
                nArray4[3][3] = nArray3[1] + nArray3[2] * 2 + nArray3[3] + 2 >> 2;
                break;
            }
            case 8: {
                int[] nArray9 = new int[]{nArray2[3], nArray2[2], nArray2[1], nArray2[0], n15, nArray[0], nArray[1], nArray[2], nArray[3]};
                nArray4[0][3] = nArray9[0] + nArray9[1] + 1 >> 1;
                nArray4[1][3] = nArray9[0] + nArray9[1] * 2 + nArray9[2] + 2 >> 2;
                int n66 = nArray9[1] + nArray9[2] + 1 >> 1;
                nArray4[2][3] = n66;
                nArray4[0][2] = n66;
                int n67 = nArray9[1] + nArray9[2] * 2 + nArray9[3] + 2 >> 2;
                nArray4[3][3] = n67;
                nArray4[1][2] = n67;
                int n68 = nArray9[2] + nArray9[3] + 1 >> 1;
                nArray4[0][1] = n68;
                nArray4[2][2] = n68;
                int n69 = nArray9[2] + nArray9[3] * 2 + nArray9[4] + 2 >> 2;
                nArray4[1][1] = n69;
                nArray4[3][2] = n69;
                int n75 = nArray9[3] + nArray9[4] + 1 >> 1;
                nArray4[0][0] = n75;
                nArray4[2][1] = n75;
                int n76 = nArray9[3] + nArray9[4] * 2 + nArray9[5] + 2 >> 2;
                nArray4[1][0] = n76;
                nArray4[3][1] = n76;
                nArray4[2][0] = nArray9[4] + nArray9[5] * 2 + nArray9[6] + 2 >> 2;
                nArray4[3][0] = nArray9[5] + nArray9[6] * 2 + nArray9[7] + 2 >> 2;
                break;
            }
            case 9: {
                nArray4[0][0] = nArray2[0] + nArray2[1] + 1 >> 1;
                nArray4[1][0] = nArray2[0] + nArray2[1] * 2 + nArray2[2] + 2 >> 2;
                int n77 = nArray2[1] + nArray2[2] + 1 >> 1;
                nArray4[0][1] = n77;
                nArray4[2][0] = n77;
                int n78 = nArray2[1] + nArray2[2] * 2 + nArray2[3] + 2 >> 2;
                nArray4[1][1] = n78;
                nArray4[3][0] = n78;
                int n79 = nArray2[2] + nArray2[3] + 1 >> 1;
                nArray4[0][2] = n79;
                nArray4[2][1] = n79;
                int n85 = nArray2[2] + nArray2[3] * 2 + nArray2[3] + 2 >> 2;
                nArray4[1][2] = n85;
                nArray4[3][1] = n85;
                int n86 = nArray2[3];
                nArray4[3][3] = n86;
                nArray4[2][3] = n86;
                nArray4[1][3] = n86;
                nArray4[0][3] = n86;
                nArray4[3][2] = n86;
                nArray4[2][2] = n86;
                break;
            }
            default: {
                throw new AssertionError((Object)("TODO mode: " + subBlock.getMode()));
            }
        }
        subBlock.setPredict(nArray4);
    }

    public void reconstruct() {
        SubBlock subBlock = this;
        int[][] nArray = subBlock.getPredict(1, false);
        int[][] nArray2 = new int[4][4];
        int[][] nArray3 = subBlock.getDiff();
        for (int i15 = 0; i15 < 4; ++i15) {
            for (int i16 = 0; i16 < 4; ++i16) {
                int n15 = nArray3[i15][i16] + nArray[i15][i16];
                if (n15 < 0) {
                    n15 = 0;
                }
                if (n15 > 255) {
                    n15 = 255;
                }
                nArray2[i15][i16] = n15;
            }
        }
        subBlock.setDest(nArray2);
        if (!this.getMacroBlock().isKeepDebugInfo()) {
            subBlock.diff = null;
            subBlock.predict = null;
            subBlock.tokens = null;
        }
    }

    public void setDest(int[][] nArray) {
        this.dest = nArray;
    }

    public void setDiff(int[][] nArray) {
        this.diff = nArray;
    }

    public void setMode(int n15) {
        this.mode = n15;
    }

    public void setPixel(int n15, int n16, int n17) {
        if (this.dest == null) {
            this.dest = new int[4][4];
        }
        this.dest[n15][n16] = n17;
    }

    public void setPredict(int[][] nArray) {
        this.predict = nArray;
    }

    public String toString() {
        String string = "[";
        for (int i15 = 0; i15 < 16; ++i15) {
            string = string + this.tokens[i15] + " ";
        }
        string = string + "]";
        return string;
    }

    public static enum Plane {
        U,
        V,
        Y1,
        Y2;

    }
}

