/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class DisposableLambdaObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> downstream;
    final Consumer<? super Disposable> onSubscribe;
    final Action onDispose;
    Disposable upstream;

    public DisposableLambdaObserver(Observer<? super T> actual, Consumer<? super Disposable> onSubscribe, Action onDispose) {
        this.downstream = actual;
        this.onSubscribe = onSubscribe;
        this.onDispose = onDispose;
    }

    @Override
    public void onSubscribe(Disposable d15) {
        try {
            this.onSubscribe.accept(d15);
        }
        catch (Throwable e15) {
            Exceptions.throwIfFatal(e15);
            d15.dispose();
            this.upstream = DisposableHelper.DISPOSED;
            EmptyDisposable.error(e15, this.downstream);
            return;
        }
        if (DisposableHelper.validate(this.upstream, d15)) {
            this.upstream = d15;
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t15) {
        this.downstream.onNext(t15);
    }

    @Override
    public void onError(Throwable t15) {
        if (this.upstream != DisposableHelper.DISPOSED) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onError(t15);
        } else {
            RxJavaPlugins.onError(t15);
        }
    }

    @Override
    public void onComplete() {
        if (this.upstream != DisposableHelper.DISPOSED) {
            this.upstream = DisposableHelper.DISPOSED;
            this.downstream.onComplete();
        }
    }

    @Override
    public void dispose() {
        Disposable d15 = this.upstream;
        if (d15 != DisposableHelper.DISPOSED) {
            this.upstream = DisposableHelper.DISPOSED;
            try {
                this.onDispose.run();
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                RxJavaPlugins.onError(e15);
            }
            d15.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }
}

