/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.InnerQueuedObserverSupport;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.operators.SimpleQueue;
import java.util.concurrent.atomic.AtomicReference;

public final class InnerQueuedObserver<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -5417183359794346637L;
    final InnerQueuedObserverSupport<T> parent;
    final int prefetch;
    SimpleQueue<T> queue;
    volatile boolean done;
    int fusionMode;

    public InnerQueuedObserver(InnerQueuedObserverSupport<T> parent, int prefetch) {
        this.parent = parent;
        this.prefetch = prefetch;
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (DisposableHelper.setOnce(this, d15)) {
            if (d15 instanceof QueueDisposable) {
                QueueDisposable qd5 = (QueueDisposable)d15;
                int m15 = qd5.requestFusion(3);
                if (m15 == 1) {
                    this.fusionMode = m15;
                    this.queue = qd5;
                    this.done = true;
                    this.parent.innerComplete(this);
                    return;
                }
                if (m15 == 2) {
                    this.fusionMode = m15;
                    this.queue = qd5;
                    return;
                }
            }
            this.queue = QueueDrainHelper.createQueue(-this.prefetch);
        }
    }

    @Override
    public void onNext(T t15) {
        if (this.fusionMode == 0) {
            this.parent.innerNext(this, t15);
        } else {
            this.parent.drain();
        }
    }

    @Override
    public void onError(Throwable t15) {
        this.parent.innerError(this, t15);
    }

    @Override
    public void onComplete() {
        this.parent.innerComplete(this);
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public SimpleQueue<T> queue() {
        return this.queue;
    }
}

