/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;

public final class CompletableDoOnEvent
extends Completable {
    final CompletableSource source;
    final Consumer<? super Throwable> onEvent;

    public CompletableDoOnEvent(CompletableSource source, Consumer<? super Throwable> onEvent) {
        this.source = source;
        this.onEvent = onEvent;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new DoOnEvent(observer));
    }

    final class DoOnEvent
    implements CompletableObserver {
        private final CompletableObserver observer;

        DoOnEvent(CompletableObserver observer) {
            this.observer = observer;
        }

        @Override
        public void onComplete() {
            try {
                CompletableDoOnEvent.this.onEvent.accept(null);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.observer.onError(e15);
                return;
            }
            this.observer.onComplete();
        }

        @Override
        public void onError(Throwable e15) {
            try {
                CompletableDoOnEvent.this.onEvent.accept(e15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                e15 = new CompositeException(e15, ex4);
            }
            this.observer.onError(e15);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.observer.onSubscribe(d15);
        }
    }
}

