/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatMap;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapScheduler<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int prefetch;
    final ErrorMode errorMode;
    final Scheduler scheduler;

    public FlowableConcatMapScheduler(Flowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, ErrorMode errorMode, Scheduler scheduler) {
        super(source);
        this.mapper = mapper;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        switch (this.errorMode) {
            case BOUNDARY: {
                this.source.subscribe(new ConcatMapDelayed<T, R>(s15, this.mapper, this.prefetch, false, this.scheduler.createWorker()));
                break;
            }
            case END: {
                this.source.subscribe(new ConcatMapDelayed<T, R>(s15, this.mapper, this.prefetch, true, this.scheduler.createWorker()));
                break;
            }
            default: {
                this.source.subscribe(new ConcatMapImmediate<T, R>(s15, this.mapper, this.prefetch, this.scheduler.createWorker()));
            }
        }
    }

    static final class ConcatMapDelayed<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = -2945777694260521066L;
        final Subscriber<? super R> downstream;
        final boolean veryEnd;

        ConcatMapDelayed(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, boolean veryEnd, Scheduler.Worker worker) {
            super(mapper, prefetch, worker);
            this.downstream = actual;
            this.veryEnd = veryEnd;
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.done = true;
                this.schedule();
            }
        }

        @Override
        public void innerNext(R value) {
            this.downstream.onNext(value);
        }

        @Override
        public void innerError(Throwable e15) {
            if (this.errors.tryAddThrowableOrReport(e15)) {
                if (!this.veryEnd) {
                    this.upstream.cancel();
                    this.done = true;
                }
                this.active = false;
                this.schedule();
            }
        }

        @Override
        public void request(long n15) {
            this.inner.request(n15);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.worker.dispose();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule(this);
            }
        }

        @Override
        public void run() {
            while (true) {
                if (this.cancelled) {
                    return;
                }
                if (!this.active) {
                    boolean empty;
                    Object v15;
                    Throwable ex4;
                    boolean d15 = this.done;
                    if (d15 && !this.veryEnd && (ex4 = (Throwable)this.errors.get()) != null) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    try {
                        v15 = this.queue.poll();
                    }
                    catch (Throwable e15) {
                        Exceptions.throwIfFatal(e15);
                        this.upstream.cancel();
                        this.errors.tryAddThrowableOrReport(e15);
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    if (!empty) {
                        Publisher p15;
                        try {
                            p15 = (Publisher)Objects.requireNonNull(this.mapper.apply(v15), "The mapper returned a null Publisher");
                        }
                        catch (Throwable e16) {
                            Exceptions.throwIfFatal(e16);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e16);
                            this.errors.tryTerminateConsumer(this.downstream);
                            this.worker.dispose();
                            return;
                        }
                        if (this.sourceMode != 1) {
                            int c15 = this.consumed + 1;
                            if (c15 == this.limit) {
                                this.consumed = 0;
                                this.upstream.request(c15);
                            } else {
                                this.consumed = c15;
                            }
                        }
                        if (p15 instanceof Supplier) {
                            Object vr4;
                            Supplier supplier = (Supplier)((Object)p15);
                            try {
                                vr4 = supplier.get();
                            }
                            catch (Throwable e17) {
                                Exceptions.throwIfFatal(e17);
                                this.errors.tryAddThrowableOrReport(e17);
                                if (!this.veryEnd) {
                                    this.upstream.cancel();
                                    this.errors.tryTerminateConsumer(this.downstream);
                                    this.worker.dispose();
                                    return;
                                }
                                vr4 = null;
                            }
                            if (vr4 == null || this.cancelled) continue;
                            if (this.inner.isUnbounded()) {
                                this.downstream.onNext(vr4);
                                continue;
                            }
                            this.active = true;
                            this.inner.setSubscription(new FlowableConcatMap.SimpleScalarSubscription(vr4, this.inner));
                        } else {
                            this.active = true;
                            p15.subscribe(this.inner);
                        }
                    }
                }
                if (this.decrementAndGet() == 0) break;
            }
        }
    }

    static final class ConcatMapImmediate<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = 7898995095634264146L;
        final Subscriber<? super R> downstream;
        final AtomicInteger wip;

        ConcatMapImmediate(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, Scheduler.Worker worker) {
            super(mapper, prefetch, worker);
            this.downstream = actual;
            this.wip = new AtomicInteger();
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.inner.cancel();
                if (this.getAndIncrement() == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    this.worker.dispose();
                }
            }
        }

        boolean tryEnter() {
            return this.get() == 0 && this.compareAndSet(0, 1);
        }

        @Override
        public void innerNext(R value) {
            if (this.tryEnter()) {
                this.downstream.onNext(value);
                if (this.compareAndSet(1, 0)) {
                    return;
                }
                this.errors.tryTerminateConsumer(this.downstream);
                this.worker.dispose();
            }
        }

        @Override
        public void innerError(Throwable e15) {
            if (this.errors.tryAddThrowableOrReport(e15)) {
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    this.worker.dispose();
                }
            }
        }

        @Override
        public void request(long n15) {
            this.inner.request(n15);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.worker.dispose();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void schedule() {
            if (this.wip.getAndIncrement() == 0) {
                this.worker.schedule(this);
            }
        }

        @Override
        public void run() {
            while (true) {
                if (this.cancelled) {
                    return;
                }
                if (!this.active) {
                    boolean empty;
                    Object v15;
                    boolean d15 = this.done;
                    try {
                        v15 = this.queue.poll();
                    }
                    catch (Throwable e15) {
                        Exceptions.throwIfFatal(e15);
                        this.upstream.cancel();
                        this.errors.tryAddThrowableOrReport(e15);
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        this.downstream.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (!empty) {
                        Publisher p15;
                        try {
                            p15 = (Publisher)Objects.requireNonNull(this.mapper.apply(v15), "The mapper returned a null Publisher");
                        }
                        catch (Throwable e16) {
                            Exceptions.throwIfFatal(e16);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e16);
                            this.errors.tryTerminateConsumer(this.downstream);
                            this.worker.dispose();
                            return;
                        }
                        if (this.sourceMode != 1) {
                            int c15 = this.consumed + 1;
                            if (c15 == this.limit) {
                                this.consumed = 0;
                                this.upstream.request(c15);
                            } else {
                                this.consumed = c15;
                            }
                        }
                        if (p15 instanceof Supplier) {
                            Object vr4;
                            Supplier supplier = (Supplier)((Object)p15);
                            try {
                                vr4 = supplier.get();
                            }
                            catch (Throwable e17) {
                                Exceptions.throwIfFatal(e17);
                                this.upstream.cancel();
                                this.errors.tryAddThrowableOrReport(e17);
                                this.errors.tryTerminateConsumer(this.downstream);
                                this.worker.dispose();
                                return;
                            }
                            if (vr4 == null || this.cancelled) continue;
                            if (this.inner.isUnbounded()) {
                                if (!this.tryEnter()) continue;
                                this.downstream.onNext(vr4);
                                if (this.compareAndSet(1, 0)) continue;
                                this.errors.tryTerminateConsumer(this.downstream);
                                this.worker.dispose();
                                return;
                            }
                            this.active = true;
                            this.inner.setSubscription(new FlowableConcatMap.SimpleScalarSubscription(vr4, this.inner));
                        } else {
                            this.active = true;
                            p15.subscribe(this.inner);
                        }
                    }
                }
                if (this.wip.decrementAndGet() == 0) break;
            }
        }
    }

    static abstract class BaseConcatMapSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    FlowableConcatMap.ConcatMapSupport<R>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -3511336836796789179L;
        final FlowableConcatMap.ConcatMapInner<R> inner;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int prefetch;
        final int limit;
        final Scheduler.Worker worker;
        Subscription upstream;
        int consumed;
        SimpleQueue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicThrowable errors;
        volatile boolean active;
        int sourceMode;

        BaseConcatMapSubscriber(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, Scheduler.Worker worker) {
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.inner = new FlowableConcatMap.ConcatMapInner(this);
            this.errors = new AtomicThrowable();
            this.worker = worker;
        }

        @Override
        public final void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription f15 = (QueueSubscription)s15;
                    int m15 = f15.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = f15;
                        this.done = true;
                        this.subscribeActual();
                        this.schedule();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = f15;
                        this.subscribeActual();
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.subscribeActual();
                s15.request(this.prefetch);
            }
        }

        abstract void schedule();

        abstract void subscribeActual();

        @Override
        public final void onNext(T t15) {
            if (this.sourceMode != 2 && !this.queue.offer(t15)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.schedule();
        }

        @Override
        public final void onComplete() {
            this.done = true;
            this.schedule();
        }

        @Override
        public final void innerComplete() {
            this.active = false;
            this.schedule();
        }
    }
}

