/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableDoAfterNext<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onAfterNext;

    public FlowableDoAfterNext(Flowable<T> source, Consumer<? super T> onAfterNext) {
        super(source);
        this.onAfterNext = onAfterNext;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        if (s15 instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoAfterConditionalSubscriber<T>((ConditionalSubscriber)s15, this.onAfterNext));
        } else {
            this.source.subscribe(new DoAfterSubscriber<T>(s15, this.onAfterNext));
        }
    }

    static final class DoAfterConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Consumer<? super T> onAfterNext;

        DoAfterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onAfterNext) {
            super(actual);
            this.onAfterNext = onAfterNext;
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
            if (this.sourceMode == 0) {
                try {
                    this.onAfterNext.accept(t15);
                }
                catch (Throwable ex4) {
                    this.fail(ex4);
                }
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            boolean b15 = this.downstream.tryOnNext(t15);
            try {
                this.onAfterNext.accept(t15);
            }
            catch (Throwable ex4) {
                this.fail(ex4);
            }
            return b15;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15 = this.qs.poll();
            if (v15 != null) {
                this.onAfterNext.accept(v15);
            }
            return v15;
        }
    }

    static final class DoAfterSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Consumer<? super T> onAfterNext;

        DoAfterSubscriber(Subscriber<? super T> actual, Consumer<? super T> onAfterNext) {
            super(actual);
            this.onAfterNext = onAfterNext;
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            this.downstream.onNext(t15);
            if (this.sourceMode == 0) {
                try {
                    this.onAfterNext.accept(t15);
                }
                catch (Throwable ex4) {
                    this.fail(ex4);
                }
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v15 = this.qs.poll();
            if (v15 != null) {
                this.onAfterNext.accept(v15);
            }
            return v15;
        }
    }
}

