/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.operators.QueueSubscription;
import org.reactivestreams.Subscriber;

public final class FlowableFilter<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public FlowableFilter(Flowable<T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        if (s15 instanceof ConditionalSubscriber) {
            this.source.subscribe(new FilterConditionalSubscriber<T>((ConditionalSubscriber)s15, this.predicate));
        } else {
            this.source.subscribe(new FilterSubscriber<T>(s15, this.predicate));
        }
    }

    static final class FilterConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Predicate<? super T> filter;

        FilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> filter) {
            super(actual);
            this.filter = filter;
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            boolean b15;
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                return this.downstream.tryOnNext(null);
            }
            try {
                b15 = this.filter.test(t15);
            }
            catch (Throwable e15) {
                this.fail(e15);
                return true;
            }
            return b15 && this.downstream.tryOnNext(t15);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            QueueSubscription qs4 = this.qs;
            Predicate f15 = this.filter;
            Object t15;
            while ((t15 = qs4.poll()) != null) {
                if (f15.test(t15)) {
                    return t15;
                }
                if (this.sourceMode != 2) continue;
                qs4.request(1L);
            }
            return null;
        }
    }

    static final class FilterSubscriber<T>
    extends BasicFuseableSubscriber<T, T>
    implements ConditionalSubscriber<T> {
        final Predicate<? super T> filter;

        FilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> filter) {
            super(actual);
            this.filter = filter;
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            boolean b15;
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return true;
            }
            try {
                b15 = this.filter.test(t15);
            }
            catch (Throwable e15) {
                this.fail(e15);
                return true;
            }
            if (b15) {
                this.downstream.onNext(t15);
            }
            return b15;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            QueueSubscription qs4 = this.qs;
            Predicate f15 = this.filter;
            Object t15;
            while ((t15 = qs4.poll()) != null) {
                if (f15.test(t15)) {
                    return t15;
                }
                if (this.sourceMode != 2) continue;
                qs4.request(1L);
            }
            return null;
        }
    }
}

