/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableReduce<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiFunction<T, T, T> reducer;

    public FlowableReduce(Flowable<T> source, BiFunction<T, T, T> reducer) {
        super(source);
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new ReduceSubscriber<T>(s15, this.reducer));
    }

    static final class ReduceSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -4663883003264602070L;
        final BiFunction<T, T, T> reducer;
        Subscription upstream;

        ReduceSubscriber(Subscriber<? super T> actual, BiFunction<T, T, T> reducer) {
            super(actual);
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.upstream == SubscriptionHelper.CANCELLED) {
                return;
            }
            Object v15 = this.value;
            if (v15 == null) {
                this.value = t15;
            } else {
                try {
                    this.value = Objects.requireNonNull(this.reducer.apply(v15, t15), "The reducer returned a null value");
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.upstream.cancel();
                    this.onError(ex4);
                }
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.upstream == SubscriptionHelper.CANCELLED) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.upstream = SubscriptionHelper.CANCELLED;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.upstream == SubscriptionHelper.CANCELLED) {
                return;
            }
            this.upstream = SubscriptionHelper.CANCELLED;
            Object v15 = this.value;
            if (v15 != null) {
                this.complete(v15);
            } else {
                this.downstream.onComplete();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELLED;
        }
    }
}

