/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.UnicastSubject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableGroupJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends AbstractObservableWithUpstream<TLeft, R> {
    final ObservableSource<? extends TRight> other;
    final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector;

    public ObservableGroupJoin(ObservableSource<TLeft> source, ObservableSource<? extends TRight> other, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector) {
        super(source);
        this.other = other;
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.resultSelector = resultSelector;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        GroupJoinDisposable parent = new GroupJoinDisposable(observer, this.leftEnd, this.rightEnd, this.resultSelector);
        observer.onSubscribe(parent);
        LeftRightObserver left = new LeftRightObserver(parent, true);
        parent.disposables.add(left);
        LeftRightObserver right = new LeftRightObserver(parent, false);
        parent.disposables.add(right);
        this.source.subscribe(left);
        this.other.subscribe(right);
    }

    static final class LeftRightEndObserver
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = 1883890389173668373L;
        final JoinSupport parent;
        final boolean isLeft;
        final int index;

        LeftRightEndObserver(JoinSupport parent, boolean isLeft, int index) {
            this.parent = parent;
            this.isLeft = isLeft;
            this.index = index;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this, d15);
        }

        @Override
        public void onNext(Object t15) {
            if (DisposableHelper.dispose(this)) {
                this.parent.innerClose(this.isLeft, this);
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerCloseError(t15);
        }

        @Override
        public void onComplete() {
            this.parent.innerClose(this.isLeft, this);
        }
    }

    static final class LeftRightObserver
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = 1883890389173668373L;
        final JoinSupport parent;
        final boolean isLeft;

        LeftRightObserver(JoinSupport parent, boolean isLeft) {
            this.parent = parent;
            this.isLeft = isLeft;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this, d15);
        }

        @Override
        public void onNext(Object t15) {
            this.parent.innerValue(this.isLeft, t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerError(t15);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this);
        }
    }

    static final class GroupJoinDisposable<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements Disposable,
    JoinSupport {
        private static final long serialVersionUID = -6071216598687999801L;
        final Observer<? super R> downstream;
        final SpscLinkedArrayQueue<Object> queue;
        final CompositeDisposable disposables;
        final Map<Integer, UnicastSubject<TRight>> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
        final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
        final BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        GroupJoinDisposable(Observer<? super R> actual, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Observable<TRight>, ? extends R> resultSelector) {
            this.downstream = actual;
            this.disposables = new CompositeDisposable();
            this.queue = new SpscLinkedArrayQueue(Observable.bufferSize());
            this.lefts = new LinkedHashMap<Integer, UnicastSubject<TRight>>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void dispose() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(Observer<?> a15) {
            Throwable ex4 = ExceptionHelper.terminate(this.error);
            for (UnicastSubject<TRight> up4 : this.lefts.values()) {
                up4.onError(ex4);
            }
            this.lefts.clear();
            this.rights.clear();
            a15.onError(ex4);
        }

        void fail(Throwable exc, Observer<?> a15, SpscLinkedArrayQueue<?> q15) {
            Exceptions.throwIfFatal(exc);
            ExceptionHelper.addThrowable(this.error, exc);
            q15.clear();
            this.cancelAll();
            this.errorAll(a15);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            Observer<R> a15 = this.downstream;
            block6: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q15.clear();
                    return;
                }
                Throwable ex4 = this.error.get();
                if (ex4 != null) {
                    q15.clear();
                    this.cancelAll();
                    this.errorAll(a15);
                    return;
                }
                boolean d15 = this.active.get() == 0;
                Integer mode = (Integer)q15.poll();
                boolean bl4 = empty = mode == null;
                if (d15 && empty) {
                    for (UnicastSubject<TRight> up4 : this.lefts.values()) {
                        up4.onComplete();
                    }
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a15.onComplete();
                    return;
                }
                if (!empty) {
                    LeftRightEndObserver end;
                    Object val = q15.poll();
                    if (mode == LEFT_VALUE) {
                        R w15;
                        ObservableSource<TLeftEnd> p15;
                        int idx;
                        Object left = val;
                        UnicastSubject<TRight> up5 = UnicastSubject.create();
                        ++this.leftIndex;
                        this.lefts.put(idx, up5);
                        try {
                            p15 = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a15, q15);
                            return;
                        }
                        LeftRightEndObserver end2 = new LeftRightEndObserver(this, true, idx);
                        this.disposables.add(end2);
                        p15.subscribe(end2);
                        ex4 = this.error.get();
                        if (ex4 != null) {
                            q15.clear();
                            this.cancelAll();
                            this.errorAll(a15);
                            return;
                        }
                        try {
                            w15 = Objects.requireNonNull(this.resultSelector.apply(left, up5), "The resultSelector returned a null value");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a15, q15);
                            return;
                        }
                        a15.onNext(w15);
                        Iterator<TRight> iterator2 = this.rights.values().iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block6;
                            TRight right = iterator2.next();
                            up5.onNext(right);
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        ObservableSource<TRightEnd> p16;
                        int idx;
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p16 = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a15, q15);
                            return;
                        }
                        LeftRightEndObserver end3 = new LeftRightEndObserver(this, false, idx);
                        this.disposables.add(end3);
                        p16.subscribe(end3);
                        ex4 = this.error.get();
                        if (ex4 != null) {
                            q15.clear();
                            this.cancelAll();
                            this.errorAll(a15);
                            return;
                        }
                        Iterator<UnicastSubject<TRight>> iterator3 = this.lefts.values().iterator();
                        while (true) {
                            if (!iterator3.hasNext()) continue block6;
                            UnicastSubject<TRight> up6 = iterator3.next();
                            up6.onNext(right);
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (LeftRightEndObserver)val;
                        UnicastSubject<TRight> up7 = this.lefts.remove(end.index);
                        this.disposables.remove(end);
                        if (up7 == null) continue;
                        up7.onComplete();
                        continue;
                    }
                    end = (LeftRightEndObserver)val;
                    this.rights.remove(end.index);
                    this.disposables.remove(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex4) {
            if (ExceptionHelper.addThrowable(this.error, ex4)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }

        @Override
        public void innerComplete(LeftRightObserver sender) {
            this.disposables.delete(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o15) {
            GroupJoinDisposable groupJoinDisposable = this;
            synchronized (groupJoinDisposable) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o15);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, LeftRightEndObserver index) {
            GroupJoinDisposable groupJoinDisposable = this;
            synchronized (groupJoinDisposable) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex4) {
            if (ExceptionHelper.addThrowable(this.error, ex4)) {
                this.drain();
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }
    }

    static interface JoinSupport {
        public void innerError(Throwable var1);

        public void innerComplete(LeftRightObserver var1);

        public void innerValue(boolean var1, Object var2);

        public void innerClose(boolean var1, LeftRightEndObserver var2);

        public void innerCloseError(Throwable var1);
    }
}

