/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public class SubscriptionArbiter
extends AtomicInteger
implements Subscription {
    private static final long serialVersionUID = -2189523197179400958L;
    Subscription actual;
    long requested;
    final AtomicReference<Subscription> missedSubscription;
    final AtomicLong missedRequested;
    final AtomicLong missedProduced;
    final boolean cancelOnReplace;
    volatile boolean cancelled;
    protected boolean unbounded;

    public SubscriptionArbiter(boolean cancelOnReplace) {
        this.cancelOnReplace = cancelOnReplace;
        this.missedSubscription = new AtomicReference();
        this.missedRequested = new AtomicLong();
        this.missedProduced = new AtomicLong();
    }

    public final void setSubscription(Subscription s15) {
        if (this.cancelled) {
            s15.cancel();
            return;
        }
        Objects.requireNonNull(s15, "s is null");
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            Subscription a15 = this.actual;
            if (a15 != null && this.cancelOnReplace) {
                a15.cancel();
            }
            this.actual = s15;
            long r15 = this.requested;
            if (this.decrementAndGet() != 0) {
                this.drainLoop();
            }
            if (r15 != 0L) {
                s15.request(r15);
            }
            return;
        }
        Subscription a16 = this.missedSubscription.getAndSet(s15);
        if (a16 != null && this.cancelOnReplace) {
            a16.cancel();
        }
        this.drain();
    }

    @Override
    public final void request(long n15) {
        if (SubscriptionHelper.validate(n15)) {
            if (this.unbounded) {
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r15 = this.requested;
                if (r15 != Long.MAX_VALUE) {
                    this.requested = r15 = BackpressureHelper.addCap(r15, n15);
                    if (r15 == Long.MAX_VALUE) {
                        this.unbounded = true;
                    }
                }
                Subscription a15 = this.actual;
                if (this.decrementAndGet() != 0) {
                    this.drainLoop();
                }
                if (a15 != null) {
                    a15.request(n15);
                }
                return;
            }
            BackpressureHelper.add(this.missedRequested, n15);
            this.drain();
        }
    }

    public final void produced(long n15) {
        if (this.unbounded) {
            return;
        }
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            long r15 = this.requested;
            if (r15 != Long.MAX_VALUE) {
                long u15 = r15 - n15;
                if (u15 < 0L) {
                    SubscriptionHelper.reportMoreProduced(u15);
                    u15 = 0L;
                }
                this.requested = u15;
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
            this.drainLoop();
            return;
        }
        BackpressureHelper.add(this.missedProduced, n15);
        this.drain();
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.drain();
        }
    }

    final void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        this.drainLoop();
    }

    final void drainLoop() {
        int missed = 1;
        long requestAmount = 0L;
        Subscription requestTarget = null;
        do {
            long mp4;
            long mr4;
            Subscription ms4;
            if ((ms4 = this.missedSubscription.get()) != null) {
                ms4 = this.missedSubscription.getAndSet(null);
            }
            if ((mr4 = this.missedRequested.get()) != 0L) {
                mr4 = this.missedRequested.getAndSet(0L);
            }
            if ((mp4 = this.missedProduced.get()) != 0L) {
                mp4 = this.missedProduced.getAndSet(0L);
            }
            Subscription a15 = this.actual;
            if (this.cancelled) {
                if (a15 != null) {
                    a15.cancel();
                    this.actual = null;
                }
                if (ms4 == null) continue;
                ms4.cancel();
                continue;
            }
            long r15 = this.requested;
            if (r15 != Long.MAX_VALUE) {
                long u15 = BackpressureHelper.addCap(r15, mr4);
                if (u15 != Long.MAX_VALUE) {
                    long v15 = u15 - mp4;
                    if (v15 < 0L) {
                        SubscriptionHelper.reportMoreProduced(v15);
                        v15 = 0L;
                    }
                    r15 = v15;
                } else {
                    r15 = u15;
                }
                this.requested = r15;
            }
            if (ms4 != null) {
                if (a15 != null && this.cancelOnReplace) {
                    a15.cancel();
                }
                this.actual = ms4;
                if (r15 == 0L) continue;
                requestAmount = BackpressureHelper.addCap(requestAmount, r15);
                requestTarget = ms4;
                continue;
            }
            if (a15 == null || mr4 == 0L) continue;
            requestAmount = BackpressureHelper.addCap(requestAmount, mr4);
            requestTarget = a15;
        } while ((missed = this.addAndGet(-missed)) != 0);
        if (requestAmount != 0L) {
            requestTarget.request(requestAmount);
        }
    }

    public final boolean isUnbounded() {
        return this.unbounded;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }
}

