/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SerializedObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> downstream;
    final boolean delayError;
    static final int QUEUE_LINK_SIZE = 4;
    Disposable upstream;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    public SerializedObserver(@NonNull Observer<? super T> downstream) {
        this(downstream, false);
    }

    public SerializedObserver(@NonNull Observer<? super T> actual, boolean delayError) {
        this.downstream = actual;
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(@NonNull Disposable d15) {
        if (DisposableHelper.validate(this.upstream, d15)) {
            this.upstream = d15;
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.done = true;
        this.upstream.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(@NonNull T t15) {
        if (this.done) {
            return;
        }
        if (t15 == null) {
            this.upstream.dispose();
            this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                if (q15 == null) {
                    this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                }
                q15.add(NotificationLite.next(t15));
                return;
            }
            this.emitting = true;
        }
        this.downstream.onNext(t15);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(@NonNull Throwable t15) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                reportError = true;
            } else {
                if (this.emitting) {
                    this.done = true;
                    AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                    if (q15 == null) {
                        q15 = new AppendOnlyLinkedArrayList(4);
                        this.queue = q15;
                    }
                    Object err = NotificationLite.error(t15);
                    if (this.delayError) {
                        q15.add(err);
                    } else {
                        q15.setFirst(err);
                    }
                    return;
                }
                this.done = true;
                this.emitting = true;
                reportError = false;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.downstream.onError(t15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                if (q15 == null) {
                    this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                }
                q15.add(NotificationLite.complete());
                return;
            }
            this.done = true;
            this.emitting = true;
        }
        this.downstream.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        AppendOnlyLinkedArrayList<Object> q15;
        do {
            SerializedObserver serializedObserver = this;
            synchronized (serializedObserver) {
                q15 = this.queue;
                if (q15 == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
        } while (!q15.accept(this.downstream));
    }
}

