/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeSubject<T>
extends Maybe<T>
implements MaybeObserver<T> {
    final AtomicReference<MaybeDisposable<T>[]> observers;
    static final MaybeDisposable[] EMPTY = new MaybeDisposable[0];
    static final MaybeDisposable[] TERMINATED = new MaybeDisposable[0];
    final AtomicBoolean once = new AtomicBoolean();
    T value;
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static <T> MaybeSubject<T> create() {
        return new MaybeSubject<T>();
    }

    MaybeSubject() {
        this.observers = new AtomicReference<MaybeDisposable[]>(EMPTY);
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (this.observers.get() == TERMINATED) {
            d15.dispose();
        }
    }

    @Override
    public void onSuccess(T value) {
        ExceptionHelper.nullCheck(value, "onSuccess called with a null value.");
        if (this.once.compareAndSet(false, true)) {
            this.value = value;
            for (MaybeDisposable md5 : this.observers.getAndSet(TERMINATED)) {
                md5.downstream.onSuccess(value);
            }
        }
    }

    @Override
    public void onError(Throwable e15) {
        ExceptionHelper.nullCheck(e15, "onError called with a null Throwable.");
        if (this.once.compareAndSet(false, true)) {
            this.error = e15;
            for (MaybeDisposable md5 : this.observers.getAndSet(TERMINATED)) {
                md5.downstream.onError(e15);
            }
        } else {
            RxJavaPlugins.onError(e15);
        }
    }

    @Override
    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            for (MaybeDisposable md5 : this.observers.getAndSet(TERMINATED)) {
                md5.downstream.onComplete();
            }
        }
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        MaybeDisposable<T> md5 = new MaybeDisposable<T>(observer, this);
        observer.onSubscribe(md5);
        if (this.add(md5)) {
            if (md5.isDisposed()) {
                this.remove(md5);
            }
        } else {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                observer.onError(ex4);
            } else {
                T v15 = this.value;
                if (v15 == null) {
                    observer.onComplete();
                } else {
                    observer.onSuccess(v15);
                }
            }
        }
    }

    boolean add(MaybeDisposable<T> inner) {
        MaybeDisposable[] b15;
        MaybeDisposable<T>[] a15;
        do {
            if ((a15 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new MaybeDisposable[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = inner;
        } while (!this.observers.compareAndSet(a15, b15));
        return true;
    }

    void remove(MaybeDisposable<T> inner) {
        MaybeDisposable[] b15;
        MaybeDisposable<T>[] a15;
        do {
            int n15;
            if ((n15 = (a15 = this.observers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != inner) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new MaybeDisposable[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.observers.compareAndSet(a15, b15));
    }

    @Nullable
    public T getValue() {
        if (this.observers.get() == TERMINATED) {
            return this.value;
        }
        return null;
    }

    public boolean hasValue() {
        return this.observers.get() == TERMINATED && this.value != null;
    }

    @Nullable
    public Throwable getThrowable() {
        if (this.observers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    public boolean hasThrowable() {
        return this.observers.get() == TERMINATED && this.error != null;
    }

    public boolean hasComplete() {
        return this.observers.get() == TERMINATED && this.value == null && this.error == null;
    }

    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }

    static final class MaybeDisposable<T>
    extends AtomicReference<MaybeSubject<T>>
    implements Disposable {
        private static final long serialVersionUID = -7650903191002190468L;
        final MaybeObserver<? super T> downstream;

        MaybeDisposable(MaybeObserver<? super T> actual, MaybeSubject<T> parent) {
            this.downstream = actual;
            this.lazySet(parent);
        }

        @Override
        public void dispose() {
            MaybeSubject parent = this.getAndSet(null);
            if (parent != null) {
                parent.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }
}

