/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.core.utils.exceptions.JadxArgsValidateException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxArgsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JadxArgsValidator.class);

    public static void validate(JadxDecompiler jadx) {
        JadxArgs args = jadx.getArgs();
        JadxArgsValidator.checkInputFiles(jadx, args);
        JadxArgsValidator.validateOutDirs(args);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Effective jadx args: {}", (Object)args);
        }
    }

    private static void checkInputFiles(JadxDecompiler jadx, JadxArgs args) {
        List<File> inputFiles = args.getInputFiles();
        if (inputFiles.isEmpty() && jadx.getCustomCodeLoaders().isEmpty()) {
            throw new JadxArgsValidateException("Please specify input file");
        }
        for (File file2 : inputFiles) {
            JadxArgsValidator.checkFile(file2);
        }
    }

    private static void validateOutDirs(JadxArgs args) {
        File outDir = args.getOutDir();
        File srcDir = args.getOutDirSrc();
        File resDir = args.getOutDirRes();
        if (outDir == null) {
            outDir = srcDir != null ? srcDir : (resDir != null ? resDir : JadxArgsValidator.makeDirFromInput(args));
            args.setOutDir(outDir);
        }
        if (srcDir == null) {
            args.setOutDirSrc(new File(args.getOutDir(), "sources"));
        }
        if (resDir == null) {
            args.setOutDirRes(new File(args.getOutDir(), "resources"));
        }
        JadxArgsValidator.checkDir(args.getOutDir(), "Output");
        JadxArgsValidator.checkDir(args.getOutDirSrc(), "Source output");
        JadxArgsValidator.checkDir(args.getOutDirRes(), "Resources output");
    }

    @NotNull
    private static File makeDirFromInput(JadxArgs args) {
        File file2;
        String name;
        int pos;
        List<File> inputFiles = args.getInputFiles();
        Object outDirName = inputFiles.isEmpty() ? "jadx-output" : ((pos = (name = (file2 = inputFiles.get(0)).getName()).lastIndexOf(46)) != -1 ? name.substring(0, pos) : name + "-jadx-output");
        LOG.info("output directory: {}", outDirName);
        return new File((String)outDirName);
    }

    private static void checkFile(File file2) {
        if (!file2.exists()) {
            throw new JadxArgsValidateException("File not found " + file2.getAbsolutePath());
        }
    }

    private static void checkDir(File dir, String desc) {
        if (dir != null && dir.exists() && !dir.isDirectory()) {
            throw new JadxArgsValidateException(desc + " directory exists as file " + String.valueOf(dir));
        }
    }

    private JadxArgsValidator() {
    }
}

