/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.input.data.annotations;

import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.attributes.IJadxAttrType;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.PinnedAttribute;
import java.util.Objects;

public class EncodedValue
extends PinnedAttribute {
    public static final EncodedValue NULL = new EncodedValue(EncodedType.ENCODED_NULL, null);
    private final EncodedType type;
    private final Object value;

    public EncodedValue(EncodedType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public EncodedType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        EncodedValue that = (EncodedValue)o15;
        return this.type == that.getType() && Objects.equals(this.value, that.getValue());
    }

    @Override
    public IJadxAttrType<? extends IJadxAttribute> getAttrType() {
        return JadxAttrType.CONSTANT_VALUE;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getValue()});
    }

    public String toString() {
        switch (this.type) {
            case ENCODED_NULL: {
                return "null";
            }
            case ENCODED_ARRAY: {
                return "[" + String.valueOf(this.value) + "]";
            }
            case ENCODED_STRING: {
                return "{STRING: \"" + String.valueOf(this.value) + "\"}";
            }
        }
        return "{" + this.type.toString().substring(8) + ": " + String.valueOf(this.value) + "}";
    }
}

