/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions;

import jadx.api.ICodeWriter;
import jadx.core.codegen.RegionGen;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.regions.AbstractRegion;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.CodegenException;
import java.util.ArrayList;
import java.util.List;

public final class Region
extends AbstractRegion {
    private final List<IContainer> blocks = new ArrayList<IContainer>(1);

    public Region(IRegion parent) {
        super(parent);
    }

    @Override
    public List<IContainer> getSubBlocks() {
        return this.blocks;
    }

    public void add(IContainer region) {
        this.updateParent(region, this);
        this.blocks.add(region);
    }

    @Override
    public void generate(RegionGen regionGen, ICodeWriter code) throws CodegenException {
        for (IContainer c15 : this.blocks) {
            regionGen.makeRegion(code, c15);
        }
    }

    @Override
    public boolean replaceSubBlock(IContainer oldBlock, IContainer newBlock) {
        int i15 = this.blocks.indexOf(oldBlock);
        if (i15 != -1) {
            this.blocks.set(i15, newBlock);
            this.updateParent(newBlock, this);
            return true;
        }
        return false;
    }

    @Override
    public String baseString() {
        StringBuilder sb5 = new StringBuilder();
        int size = this.blocks.size();
        sb5.append('(');
        sb5.append(size);
        if (size > 0) {
            sb5.append(':');
            Utils.listToString(sb5, this.blocks, "|", IContainer::baseString);
        }
        sb5.append(')');
        return sb5.toString();
    }

    public String toString() {
        return "R" + this.baseString();
    }
}

