/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.popupmenu;

import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class RecentProjectsMenuListener
implements MenuListener {
    private final MainWindow mainWindow;
    private final JMenu menu;

    public RecentProjectsMenuListener(MainWindow mainWindow, JMenu menu) {
        this.mainWindow = mainWindow;
        this.menu = menu;
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        HashSet<Path> current = new HashSet<Path>(this.mainWindow.getProject().getFilePaths());
        List<JMenuItem> items = this.mainWindow.getSettings().getRecentProjects().stream().filter(path -> !current.contains(path)).map(path -> {
            JMenuItem menuItem = new JMenuItem(path.toAbsolutePath().toString());
            menuItem.addActionListener(e15 -> this.mainWindow.open(Collections.singletonList(path)));
            return menuItem;
        }).collect(Collectors.toList());
        this.menu.removeAll();
        if (items.isEmpty()) {
            this.menu.add(new JMenuItem(NLS.str("menu.no_recent_projects")));
        } else {
            items.forEach(this.menu::add);
        }
    }

    @Override
    public void menuDeselected(MenuEvent e15) {
    }

    @Override
    public void menuCanceled(MenuEvent e15) {
    }
}

