/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.mappings.save;

import jadx.api.data.ICodeComment;
import jadx.api.data.ICodeRename;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeData;
import jadx.api.data.impl.JadxCodeRef;
import jadx.api.metadata.annotations.VarNode;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.mappings.RenameMappingsData;
import jadx.plugins.mappings.utils.DalvikToJavaBytecodeUtils;
import jadx.plugins.mappings.utils.VariablesUtils;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.mappingio.tree.VisitOrder;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingExporter {
    private static final Logger LOG = LoggerFactory.getLogger(MappingExporter.class);
    private final RootNode root;
    @Nullable
    private final MappingTreeView loadedMappingTree;

    public MappingExporter(RootNode root) {
        this.root = root;
        this.loadedMappingTree = RenameMappingsData.getTree(this.root);
    }

    public void exportMappings(Path path, JadxCodeData codeData, MappingFormat mappingFormat) {
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        HashSet<String> mappedClasses = new HashSet<String>();
        HashSet<CallSite> mappedFields = new HashSet<CallSite>();
        HashSet<CallSite> mappedMethods = new HashSet<CallSite>();
        HashSet<CallSite> methodsWithMappedElements = new HashSet<CallSite>();
        HashMap<CallSite, String> mappedMethodArgsAndVars = new HashMap<CallSite, String>();
        HashMap<CallSite, String> comments = new HashMap<CallSite, String>();
        for (ICodeRename codeRename : codeData.getRenames()) {
            if (codeRename.getNodeRef().getType().equals((Object)IJavaNodeRef.RefType.CLASS)) {
                mappedClasses.add(codeRename.getNodeRef().getDeclaringClass());
                continue;
            }
            if (codeRename.getNodeRef().getType().equals((Object)IJavaNodeRef.RefType.FIELD)) {
                mappedFields.add((CallSite)((Object)(codeRename.getNodeRef().getDeclaringClass() + codeRename.getNodeRef().getShortId())));
                continue;
            }
            if (!codeRename.getNodeRef().getType().equals((Object)IJavaNodeRef.RefType.METHOD)) continue;
            if (codeRename.getCodeRef() == null) {
                mappedMethods.add((CallSite)((Object)(codeRename.getNodeRef().getDeclaringClass() + codeRename.getNodeRef().getShortId())));
                continue;
            }
            methodsWithMappedElements.add((CallSite)((Object)(codeRename.getNodeRef().getDeclaringClass() + codeRename.getNodeRef().getShortId())));
            mappedMethodArgsAndVars.put((CallSite)((Object)(codeRename.getNodeRef().getDeclaringClass() + codeRename.getNodeRef().getShortId() + String.valueOf(codeRename.getCodeRef()))), codeRename.getNewName());
        }
        for (ICodeComment codeComment : codeData.getComments()) {
            comments.put((CallSite)((Object)(codeComment.getNodeRef().getDeclaringClass() + (codeComment.getNodeRef().getShortId() == null ? "" : codeComment.getNodeRef().getShortId()) + String.valueOf(codeComment.getCodeRef() == null ? "" : codeComment.getCodeRef()))), codeComment.getComment());
            if (codeComment.getCodeRef() == null) continue;
            methodsWithMappedElements.add((CallSite)((Object)(codeComment.getNodeRef().getDeclaringClass() + codeComment.getNodeRef().getShortId())));
        }
        try {
            String srcNamespace = "source";
            String dstNamespace = "target";
            if (this.loadedMappingTree != null && this.loadedMappingTree.getDstNamespaces() != null) {
                this.loadedMappingTree.accept(mappingTree);
            }
            mappingTree.visitHeader();
            mappingTree.visitNamespaces(srcNamespace, Collections.singletonList(dstNamespace));
            mappingTree.visitContent();
            for (ClassNode cls : this.root.getClasses()) {
                ClassInfo classInfo = cls.getClassInfo();
                String classPath = classInfo.makeRawFullName().replace('.', '/');
                String rawClassName = classInfo.getRawName();
                if (classInfo.hasAlias() && !classInfo.getAliasShortName().equals(classInfo.getShortName()) && mappedClasses.contains(rawClassName)) {
                    mappingTree.visitClass(classPath);
                    String alias = classInfo.makeAliasRawFullName().replace('.', '/');
                    if (alias.startsWith("defpackage")) {
                        alias = alias.substring("defpackage".length() + 1);
                    }
                    mappingTree.visitDstName(MappedElementKind.CLASS, 0, alias);
                }
                if (comments.containsKey(rawClassName)) {
                    mappingTree.visitClass(classPath);
                    mappingTree.visitComment(MappedElementKind.CLASS, (String)comments.get(rawClassName));
                }
                for (FieldNode fld : cls.getFields()) {
                    FieldInfo fieldInfo = fld.getFieldInfo();
                    if (fieldInfo.hasAlias() && mappedFields.contains(rawClassName + fieldInfo.getShortId())) {
                        this.visitField(mappingTree, classPath, fieldInfo.getName(), TypeGen.signature(fieldInfo.getType()));
                        mappingTree.visitDstName(MappedElementKind.FIELD, 0, fieldInfo.getAlias());
                    }
                    if (!comments.containsKey(rawClassName + fieldInfo.getShortId())) continue;
                    this.visitField(mappingTree, classPath, fieldInfo.getName(), TypeGen.signature(fieldInfo.getType()));
                    mappingTree.visitComment(MappedElementKind.FIELD, (String)comments.get(rawClassName + fieldInfo.getShortId()));
                }
                for (MethodNode mth : cls.getMethods()) {
                    MethodInfo methodInfo = mth.getMethodInfo();
                    String methodName = methodInfo.getName();
                    String methodDesc = methodInfo.getShortId().substring(methodName.length());
                    if (methodInfo.hasAlias() && mappedMethods.contains(rawClassName + methodInfo.getShortId())) {
                        this.visitMethod(mappingTree, classPath, methodName, methodDesc);
                        mappingTree.visitDstName(MappedElementKind.METHOD, 0, methodInfo.getAlias());
                    }
                    if (comments.containsKey(rawClassName + methodInfo.getShortId())) {
                        this.visitMethod(mappingTree, classPath, methodName, methodDesc);
                        mappingTree.visitComment(MappedElementKind.METHOD, (String)comments.get(rawClassName + methodInfo.getShortId()));
                    }
                    if (!methodsWithMappedElements.contains(rawClassName + methodInfo.getShortId())) continue;
                    int lvtIndex = mth.getAccessFlags().isStatic() ? 0 : 1;
                    List<VarNode> args = mth.collectArgNodes();
                    for (VarNode arg : args) {
                        String key;
                        Integer lvIndex = DalvikToJavaBytecodeUtils.getMethodArgLvIndex(arg);
                        if (lvIndex == null) {
                            lvIndex = -1;
                        }
                        if (mappedMethodArgsAndVars.containsKey(key = rawClassName + methodInfo.getShortId() + String.valueOf(JadxCodeRef.forVar(arg.getReg(), arg.getSsa())))) {
                            this.visitMethodArg(mappingTree, classPath, methodName, methodDesc, args.indexOf(arg), lvIndex);
                            mappingTree.visitDstName(MappedElementKind.METHOD_ARG, 0, (String)mappedMethodArgsAndVars.get(key));
                            mappedMethodArgsAndVars.remove(key);
                        }
                        ++lvtIndex;
                    }
                    for (VariablesUtils.VarInfo info : VariablesUtils.collect(mth)) {
                        VarNode var = info.getVar();
                        int startOpIdx = info.getStartOpIdx();
                        int endOpIdx = info.getEndOpIdx();
                        int lvIndex = DalvikToJavaBytecodeUtils.getMethodVarLvIndex(var);
                        String key = rawClassName + methodInfo.getShortId() + String.valueOf(JadxCodeRef.forVar(var.getReg(), var.getSsa()));
                        if (mappedMethodArgsAndVars.containsKey(key)) {
                            this.visitMethodVar(mappingTree, classPath, methodName, methodDesc, lvtIndex, lvIndex, startOpIdx, endOpIdx);
                            mappingTree.visitDstName(MappedElementKind.METHOD_VAR, 0, (String)mappedMethodArgsAndVars.get(key));
                        }
                        if (comments.containsKey(key = rawClassName + methodInfo.getShortId() + String.valueOf(JadxCodeRef.forInsn(startOpIdx)))) {
                            this.visitMethodVar(mappingTree, classPath, methodName, methodDesc, lvtIndex, lvIndex, startOpIdx, endOpIdx);
                            mappingTree.visitComment(MappedElementKind.METHOD_VAR, (String)comments.get(key));
                        }
                        ++lvtIndex;
                    }
                }
            }
            if (mappingFormat.hasSingleFile()) {
                FileUtils.deleteFileIfExists(path);
                FileUtils.makeDirsForFile(path);
                Files.createFile(path, new FileAttribute[0]);
            } else {
                FileUtils.makeDirs(path);
            }
            mappingTree.accept(MappingWriter.create(path, mappingFormat), VisitOrder.createByName());
            mappingTree.visitEnd();
        }
        catch (Exception e15) {
            LOG.error("Failed to save deobfuscation map file '{}'", (Object)path.toAbsolutePath(), (Object)e15);
        }
    }

    private void visitField(VisitableMappingTree tree, String classPath, String srcName, String srcDesc) throws IOException {
        tree.visitClass(classPath);
        tree.visitField(srcName, srcDesc);
    }

    private void visitMethod(VisitableMappingTree tree, String classPath, String srcName, String srcDesc) throws IOException {
        tree.visitClass(classPath);
        tree.visitMethod(srcName, srcDesc);
    }

    private void visitMethodArg(VisitableMappingTree tree, String classPath, String methodSrcName, String methodSrcDesc, int argPosition, int lvIndex) throws IOException {
        this.visitMethod(tree, classPath, methodSrcName, methodSrcDesc);
        tree.visitMethodArg(argPosition, lvIndex, null);
    }

    private void visitMethodVar(VisitableMappingTree tree, String classPath, String methodSrcName, String methodSrcDesc, int lvtIndex, int lvIndex, int startOpIdx, int endOpIdx) throws IOException {
        this.visitMethod(tree, classPath, methodSrcName, methodSrcDesc);
        tree.visitMethodVar(lvtIndex, lvIndex, startOpIdx, endOpIdx, null);
    }
}

