/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.HashMap;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.stringtemplate.StringTemplate;

public class DOTTreeGenerator {
    public static StringTemplate _treeST = new StringTemplate("digraph {\n\n\tordering=out;\n\tranksep=.4;\n\tbgcolor=\"lightgrey\"; node [shape=box, fixedsize=false, fontsize=12, fontname=\"Helvetica-bold\", fontcolor=\"blue\"\n\t\twidth=.25, height=.25, color=\"black\", fillcolor=\"white\", style=\"filled, solid, bold\"];\n\tedge [arrowsize=.5, color=\"black\", style=\"bold\"]\n\n  $nodes$\n  $edges$\n}\n");
    public static StringTemplate _nodeST = new StringTemplate("$name$ [label=\"$text$\"];\n");
    public static StringTemplate _edgeST = new StringTemplate("$parent$ -> $child$ // \"$parentText$\" -> \"$childText$\"\n");
    HashMap<Object, Integer> nodeToNumberMap = new HashMap();
    int nodeNumber = 0;

    public StringTemplate toDOT(Object tree, TreeAdaptor adaptor, StringTemplate _treeST, StringTemplate _edgeST) {
        StringTemplate treeST = _treeST.getInstanceOf();
        this.nodeNumber = 0;
        this.toDOTDefineNodes(tree, adaptor, treeST);
        this.nodeNumber = 0;
        this.toDOTDefineEdges(tree, adaptor, treeST);
        return treeST;
    }

    public StringTemplate toDOT(Object tree, TreeAdaptor adaptor) {
        return this.toDOT(tree, adaptor, _treeST, _edgeST);
    }

    public StringTemplate toDOT(Tree tree) {
        return this.toDOT(tree, new CommonTreeAdaptor());
    }

    protected void toDOTDefineNodes(Object tree, TreeAdaptor adaptor, StringTemplate treeST) {
        if (tree == null) {
            return;
        }
        int n15 = adaptor.getChildCount(tree);
        if (n15 == 0) {
            return;
        }
        StringTemplate parentNodeST = this.getNodeST(adaptor, tree);
        treeST.setAttribute("nodes", parentNodeST);
        for (int i15 = 0; i15 < n15; ++i15) {
            Object child = adaptor.getChild(tree, i15);
            StringTemplate nodeST = this.getNodeST(adaptor, child);
            treeST.setAttribute("nodes", nodeST);
            this.toDOTDefineNodes(child, adaptor, treeST);
        }
    }

    protected void toDOTDefineEdges(Object tree, TreeAdaptor adaptor, StringTemplate treeST) {
        if (tree == null) {
            return;
        }
        int n15 = adaptor.getChildCount(tree);
        if (n15 == 0) {
            return;
        }
        String parentName = "n" + this.getNodeNumber(tree);
        String parentText = adaptor.getText(tree);
        for (int i15 = 0; i15 < n15; ++i15) {
            Object child = adaptor.getChild(tree, i15);
            String childText = adaptor.getText(child);
            String childName = "n" + this.getNodeNumber(child);
            StringTemplate edgeST = _edgeST.getInstanceOf();
            edgeST.setAttribute("parent", parentName);
            edgeST.setAttribute("child", childName);
            edgeST.setAttribute("parentText", this.fixString(parentText));
            edgeST.setAttribute("childText", this.fixString(childText));
            treeST.setAttribute("edges", edgeST);
            this.toDOTDefineEdges(child, adaptor, treeST);
        }
    }

    protected StringTemplate getNodeST(TreeAdaptor adaptor, Object t15) {
        String text = adaptor.getText(t15);
        StringTemplate nodeST = _nodeST.getInstanceOf();
        String uniqueName = "n" + this.getNodeNumber(t15);
        nodeST.setAttribute("name", uniqueName);
        nodeST.setAttribute("text", this.fixString(text));
        return nodeST;
    }

    protected int getNodeNumber(Object t15) {
        Integer nI2 = this.nodeToNumberMap.get(t15);
        if (nI2 != null) {
            return nI2;
        }
        this.nodeToNumberMap.put(t15, this.nodeNumber);
        ++this.nodeNumber;
        return this.nodeNumber - 1;
    }

    protected String fixString(String in4) {
        String text = in4;
        if (text != null) {
            text = text.replaceAll("\"", "\\\\\"");
            text = text.replaceAll("\\t", "    ");
            text = text.replaceAll("\\n", "\\\\n");
            if ((text = text.replaceAll("\\r", "\\\\r")).length() > 20) {
                text = text.substring(0, 8) + "..." + text.substring(text.length() - 8);
            }
        }
        return text;
    }
}

