/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.io.IOUtils;

public abstract class ProxyReader
extends FilterReader {
    public ProxyReader(Reader delegate2) {
        super(delegate2);
    }

    protected void afterRead(int n15) throws IOException {
    }

    protected void beforeRead(int n15) throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        catch (IOException e15) {
            this.handleIOException(e15);
        }
    }

    protected void handleIOException(IOException e15) throws IOException {
        throw e15;
    }

    @Override
    public synchronized void mark(int readAheadLimit) throws IOException {
        try {
            this.in.mark(readAheadLimit);
        }
        catch (IOException e15) {
            this.handleIOException(e15);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            this.beforeRead(1);
            int c15 = this.in.read();
            this.afterRead(c15 != -1 ? 1 : -1);
            return c15;
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return -1;
        }
    }

    @Override
    public int read(char[] chr) throws IOException {
        try {
            this.beforeRead(IOUtils.length(chr));
            int n15 = this.in.read(chr);
            this.afterRead(n15);
            return n15;
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return -1;
        }
    }

    @Override
    public int read(char[] chr, int st4, int len) throws IOException {
        try {
            this.beforeRead(len);
            int n15 = this.in.read(chr, st4, len);
            this.afterRead(n15);
            return n15;
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return -1;
        }
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        try {
            this.beforeRead(IOUtils.length(target));
            int n15 = this.in.read(target);
            this.afterRead(n15);
            return n15;
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return -1;
        }
    }

    @Override
    public boolean ready() throws IOException {
        try {
            return this.in.ready();
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return false;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
        }
        catch (IOException e15) {
            this.handleIOException(e15);
        }
    }

    @Override
    public long skip(long ln4) throws IOException {
        try {
            return this.in.skip(ln4);
        }
        catch (IOException e15) {
            this.handleIOException(e15);
            return 0L;
        }
    }
}

