/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.array.ByteArrayData;
import org.exbin.auxiliary.binary_data.array.ByteArrayEditableData;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.ClipboardHandlingMode;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.EditMode;
import org.exbin.bined.EditOperation;
import org.exbin.bined.ScrollBarOrientation;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.EnterKeyHandlingMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.basic.SelectingMode;
import org.exbin.bined.basic.TabKeyHandlingMode;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CharsetCapable;
import org.exbin.bined.capability.ClipboardCapable;
import org.exbin.bined.capability.CodeCharactersCaseCapable;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.capability.EditModeCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.capability.ViewModeCapable;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.basic.DefaultCodeAreaCaret;

@ParametersAreNonnullByDefault
public class DefaultCodeAreaCommandHandler
implements CodeAreaCommandHandler {
    public static final int LAST_CONTROL_CODE = 31;
    private static final char DELETE_CHAR = '\u007f';
    private final int metaMask = CodeAreaSwingUtils.getMetaMaskDown();
    @Nonnull
    protected final CodeAreaCore codeArea;
    @Nonnull
    protected EnterKeyHandlingMode enterKeyHandlingMode = EnterKeyHandlingMode.PLATFORM_SPECIFIC;
    @Nonnull
    protected TabKeyHandlingMode tabKeyHandlingMode = TabKeyHandlingMode.PLATFORM_SPECIFIC;
    protected final boolean codeTypeSupported;
    protected final boolean viewModeSupported;
    private Clipboard clipboard;
    protected boolean canPaste = false;
    private CodeAreaSwingUtils.ClipboardData currentClipboardData = null;
    private DataFlavor binedDataFlavor;
    private DataFlavor binaryDataFlavor;

    public DefaultCodeAreaCommandHandler(CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        this.codeTypeSupported = codeArea instanceof CodeTypeCapable;
        this.viewModeSupported = codeArea instanceof ViewModeCapable;
        this.clipboard = CodeAreaSwingUtils.getClipboard();
        try {
            this.clipboard.addFlavorListener(e15 -> this.updateCanPaste());
            this.binedDataFlavor = new DataFlavor(BinaryData.class, CodeAreaUtils.BINED_CLIPBOARD_MIME_FULL);
            try {
                this.binaryDataFlavor = new DataFlavor("application/octet-stream");
            }
            catch (ClassNotFoundException ex4) {
                Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex4);
            }
            this.updateCanPaste();
        }
        catch (IllegalStateException ex5) {
            this.canPaste = false;
        }
        catch (HeadlessException ex6) {
            Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex6);
        }
    }

    @Nonnull
    public static CodeAreaCommandHandler.CodeAreaCommandHandlerFactory createDefaultCodeAreaCommandHandlerFactory() {
        return DefaultCodeAreaCommandHandler::new;
    }

    @Override
    public void sequenceBreak() {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.codeArea.isEnabled()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 37: {
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.LEFT);
                this.sequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 39: {
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.RIGHT);
                this.sequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 38: {
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.UP);
                this.sequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 40: {
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOWN);
                this.sequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 36: {
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0) {
                    this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOC_START);
                } else {
                    this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.ROW_START);
                }
                this.sequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 35: {
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0) {
                    this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOC_END);
                } else {
                    this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.ROW_END);
                }
                this.sequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 33: {
                this.scroll(ScrollingDirection.PAGE_UP);
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.PAGE_UP);
                this.sequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 34: {
                this.scroll(ScrollingDirection.PAGE_DOWN);
                this.move(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent), MovementDirection.PAGE_DOWN);
                this.sequenceBreak();
                keyEvent.consume();
                break;
            }
            case 155: {
                if (!this.changeEditOperation()) break;
                keyEvent.consume();
                break;
            }
            case 9: {
                this.tabPressed(DefaultCodeAreaCommandHandler.isSelectingMode(keyEvent));
                if (this.tabKeyHandlingMode == TabKeyHandlingMode.IGNORE) break;
                keyEvent.consume();
                break;
            }
            case 10: {
                this.enterPressed();
                if (this.enterKeyHandlingMode == EnterKeyHandlingMode.IGNORE) break;
                keyEvent.consume();
                break;
            }
            case 127: {
                EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
                if (editMode != EditMode.EXPANDING) break;
                this.deletePressed();
                keyEvent.consume();
                break;
            }
            case 8: {
                EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
                if (editMode != EditMode.EXPANDING) break;
                this.backSpacePressed();
                keyEvent.consume();
                break;
            }
            default: {
                if (((ClipboardCapable)((Object)this.codeArea)).getClipboardHandlingMode() != ClipboardHandlingMode.PROCESS) break;
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 67) {
                    this.copy();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 88) {
                    this.cut();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 86) {
                    this.paste();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) <= 0 || keyEvent.getKeyCode() != 65) break;
                this.codeArea.selectAll();
                keyEvent.consume();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char keyValue = keyEvent.getKeyChar();
        if (keyValue == '\uffff') {
            return;
        }
        if (!this.checkEditAllowed()) {
            return;
        }
        CodeAreaSection section = ((CaretCapable)((Object)this.codeArea)).getActiveSection();
        if (section != BasicCodeAreaSection.TEXT_PREVIEW) {
            int modifiersEx = keyEvent.getModifiersEx();
            if (modifiersEx == 0 || modifiersEx == 64) {
                this.pressedCharAsCode(keyValue);
            }
        } else if (keyValue > '\u001f' && keyValue != '\u007f') {
            this.pressedCharInPreview(keyValue);
        }
    }

    private void pressedCharAsCode(char keyChar) {
        CodeType codeType;
        CodeAreaCaretPosition caretPosition = ((CaretCapable)((Object)this.codeArea)).getActiveCaretPosition();
        long dataPosition = caretPosition.getDataPosition();
        int codeOffset = caretPosition.getCodeOffset();
        boolean validKey = CodeAreaUtils.isValidCodeKeyValue(keyChar, codeOffset, codeType = this.getCodeType());
        if (validKey) {
            EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
            if (this.codeArea.hasSelection() && editMode != EditMode.INPLACE) {
                this.deleteSelection();
                this.sequenceBreak();
            }
            int value = keyChar >= '0' && keyChar <= '9' ? keyChar - 48 : Character.toLowerCase(keyChar) - 97 + 10;
            BinaryData data = this.codeArea.getContentData();
            EditOperation editOperation = ((EditModeCapable)((Object)this.codeArea)).getActiveOperation();
            if (editMode == EditMode.EXPANDING && editOperation == EditOperation.INSERT) {
                if (codeOffset > 0) {
                    byte byteRest = data.getByte(dataPosition);
                    switch (codeType) {
                        case BINARY: {
                            byteRest = (byte)(byteRest & 255 >> codeOffset);
                            break;
                        }
                        case DECIMAL: {
                            byteRest = (byte)(byteRest % (codeOffset == 1 ? 100 : 10));
                            break;
                        }
                        case OCTAL: {
                            byteRest = (byte)(byteRest % (codeOffset == 1 ? 64 : 8));
                            break;
                        }
                        case HEXADECIMAL: {
                            byteRest = (byte)(byteRest & 0xF);
                            break;
                        }
                        default: {
                            throw CodeAreaUtils.getInvalidTypeException(codeType);
                        }
                    }
                    if (byteRest > 0) {
                        ((EditableBinaryData)data).insert(dataPosition + 1L, 1L);
                        ((EditableBinaryData)data).setByte(dataPosition, (byte)(data.getByte(dataPosition) - byteRest));
                        ((EditableBinaryData)data).setByte(dataPosition + 1L, byteRest);
                    }
                } else {
                    ((EditableBinaryData)data).insert(dataPosition, 1L);
                }
                this.setCodeValue(value);
            } else {
                if (editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE && dataPosition == this.codeArea.getDataSize()) {
                    ((EditableBinaryData)data).insert(dataPosition, 1L);
                }
                if (editMode != EditMode.INPLACE || dataPosition < this.codeArea.getDataSize()) {
                    this.setCodeValue(value);
                }
            }
            this.codeArea.notifyDataChanged();
            this.move(SelectingMode.NONE, MovementDirection.RIGHT);
            this.revealCursor();
        }
    }

    private void pressedCharInPreview(char keyChar) {
        if (this.isValidChar(keyChar)) {
            int length;
            EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
            CodeAreaCaretPosition caretPosition = ((CaretCapable)((Object)this.codeArea)).getActiveCaretPosition();
            long dataPosition = caretPosition.getDataPosition();
            byte[] bytes = this.charToBytes(keyChar);
            if (editMode == EditMode.INPLACE && dataPosition + (long)(length = bytes.length) > this.codeArea.getDataSize()) {
                return;
            }
            if (this.codeArea.hasSelection() && editMode != EditMode.INPLACE) {
                this.sequenceBreak();
                this.deleteSelection();
            }
            BinaryData data = this.codeArea.getContentData();
            EditOperation editOperation = ((EditModeCapable)((Object)this.codeArea)).getActiveOperation();
            if ((editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE || editMode == EditMode.INPLACE) && dataPosition < this.codeArea.getDataSize()) {
                int length2 = bytes.length;
                if (dataPosition + (long)length2 > this.codeArea.getDataSize()) {
                    length2 = (int)(this.codeArea.getDataSize() - dataPosition);
                }
                ((EditableBinaryData)data).remove(dataPosition, length2);
            }
            ((EditableBinaryData)data).insert(dataPosition, bytes);
            this.codeArea.notifyDataChanged();
            ((CaretCapable)((Object)this.codeArea)).getCodeAreaCaret().setCaretPosition(dataPosition + (long)bytes.length - 1L);
            this.move(SelectingMode.NONE, MovementDirection.RIGHT);
            this.revealCursor();
        }
    }

    private void setCodeValue(int value) {
        CodeAreaCaretPosition caretPosition = ((CaretCapable)((Object)this.codeArea)).getActiveCaretPosition();
        long dataPosition = caretPosition.getDataPosition();
        int codeOffset = caretPosition.getCodeOffset();
        BinaryData data = this.codeArea.getContentData();
        CodeType codeType = this.getCodeType();
        byte byteValue = data.getByte(dataPosition);
        byte outputValue = CodeAreaUtils.setCodeValue(byteValue, value, codeOffset, codeType);
        ((EditableBinaryData)data).setByte(dataPosition, outputValue);
    }

    @Override
    public void enterPressed() {
        String sequence;
        if (!this.checkEditAllowed()) {
            return;
        }
        if (((CaretCapable)((Object)this.codeArea)).getActiveSection() == BasicCodeAreaSection.TEXT_PREVIEW && !(sequence = this.enterKeyHandlingMode.getSequence()).isEmpty()) {
            this.pressedCharInPreview(sequence.charAt(0));
            if (sequence.length() == 2) {
                this.pressedCharInPreview(sequence.charAt(1));
            }
        }
    }

    @Override
    public void tabPressed() {
        this.tabPressed(SelectingMode.NONE);
    }

    public void tabPressed(SelectingMode selectingMode) {
        if (this.tabKeyHandlingMode == TabKeyHandlingMode.PLATFORM_SPECIFIC || this.tabKeyHandlingMode == TabKeyHandlingMode.CYCLE_TO_NEXT_SECTION || this.tabKeyHandlingMode == TabKeyHandlingMode.CYCLE_TO_PREVIOUS_SECTION) {
            if (this.viewModeSupported && ((ViewModeCapable)((Object)this.codeArea)).getViewMode() == CodeAreaViewMode.DUAL) {
                this.move(selectingMode, MovementDirection.SWITCH_SECTION);
                this.sequenceBreak();
                this.revealCursor();
            }
        } else if (((CaretCapable)((Object)this.codeArea)).getActiveSection() == BasicCodeAreaSection.TEXT_PREVIEW) {
            String sequence = this.tabKeyHandlingMode == TabKeyHandlingMode.INSERT_TAB ? "\t" : "  ";
            this.pressedCharInPreview(sequence.charAt(0));
            if (sequence.length() == 2) {
                this.pressedCharInPreview(sequence.charAt(1));
            }
        }
    }

    @Override
    public void backSpacePressed() {
        if (!this.checkEditAllowed()) {
            return;
        }
        BinaryData data = this.codeArea.getContentData();
        if (this.codeArea.hasSelection()) {
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
        } else {
            DefaultCodeAreaCaret caret = (DefaultCodeAreaCaret)((CaretCapable)((Object)this.codeArea)).getCodeAreaCaret();
            long dataPosition = ((CaretCapable)((Object)this.codeArea)).getDataPosition();
            if (dataPosition == 0L || dataPosition > this.codeArea.getDataSize()) {
                return;
            }
            caret.setCodeOffset(0);
            this.move(SelectingMode.NONE, MovementDirection.LEFT);
            caret.setCodeOffset(0);
            ((EditableBinaryData)data).remove(dataPosition - 1L, 1L);
            this.codeArea.notifyDataChanged();
            ((CaretCapable)((Object)this.codeArea)).setActiveCaretPosition(caret.getCaretPosition());
            this.revealCursor();
            this.clearSelection();
        }
    }

    @Override
    public void deletePressed() {
        if (!this.checkEditAllowed()) {
            return;
        }
        if (this.codeArea.hasSelection()) {
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
            this.revealCursor();
        } else {
            BinaryData data = this.codeArea.getContentData();
            DefaultCodeAreaCaret caret = (DefaultCodeAreaCaret)((CaretCapable)((Object)this.codeArea)).getCodeAreaCaret();
            long dataPosition = caret.getDataPosition();
            if (dataPosition >= this.codeArea.getDataSize()) {
                return;
            }
            ((EditableBinaryData)data).remove(dataPosition, 1L);
            this.codeArea.notifyDataChanged();
            if (caret.getCodeOffset() > 0) {
                caret.setCodeOffset(0);
            }
            ((CaretCapable)((Object)this.codeArea)).setActiveCaretPosition(caret.getCaretPosition());
            this.clearSelection();
            this.revealCursor();
        }
    }

    private void deleteSelection() {
        BinaryData data = this.codeArea.getContentData();
        if (!(data instanceof EditableBinaryData)) {
            throw new IllegalStateException("Data is not editable");
        }
        SelectionRange selection = ((SelectionCapable)((Object)this.codeArea)).getSelection();
        if (selection.isEmpty()) {
            return;
        }
        EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
        long first = selection.getFirst();
        long last = selection.getLast();
        long length = last - first + 1L;
        if (editMode == EditMode.INPLACE) {
            ((EditableBinaryData)data).fillData(first, length);
        } else {
            ((EditableBinaryData)data).remove(first, length);
        }
        ((CaretCapable)((Object)this.codeArea)).setActiveCaretPosition(first);
        this.clearSelection();
        this.revealCursor();
    }

    @Override
    public void delete() {
        if (!this.checkEditAllowed()) {
            return;
        }
        this.deleteSelection();
        this.codeArea.notifyDataChanged();
    }

    @Override
    public void copy() {
        SelectionRange selection = ((SelectionCapable)((Object)this.codeArea)).getSelection();
        if (!selection.isEmpty()) {
            BinaryData data = this.codeArea.getContentData();
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = data.copy(first, last - first + 1L);
            Charset charset = this.codeArea instanceof CharsetCapable ? ((CharsetCapable)((Object)this.codeArea)).getCharset() : null;
            CodeAreaSwingUtils.BinaryDataClipboardData binaryData = new CodeAreaSwingUtils.BinaryDataClipboardData(copy, this.binedDataFlavor, this.binaryDataFlavor, charset);
            this.setClipboardContent(binaryData);
        }
    }

    public void copyAsCode() {
        SelectionRange selection = ((SelectionCapable)((Object)this.codeArea)).getSelection();
        if (!selection.isEmpty()) {
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = this.codeArea.getContentData().copy(first, last - first + 1L);
            CodeType codeType = ((CodeTypeCapable)((Object)this.codeArea)).getCodeType();
            CodeCharactersCase charactersCase = ((CodeCharactersCaseCapable)((Object)this.codeArea)).getCodeCharactersCase();
            CodeAreaSwingUtils.CodeDataClipboardData binaryData = new CodeAreaSwingUtils.CodeDataClipboardData(copy, this.binaryDataFlavor, codeType, charactersCase);
            this.setClipboardContent(binaryData);
        }
    }

    private void setClipboardContent(CodeAreaSwingUtils.ClipboardData content) {
        this.clearClipboardData();
        try {
            this.currentClipboardData = content;
            this.clipboard.setContents(content, content);
        }
        catch (IllegalStateException ex4) {
            this.clearClipboardData();
        }
    }

    private void clearClipboardData() {
        if (this.currentClipboardData != null) {
            this.currentClipboardData.dispose();
            this.currentClipboardData = null;
        }
    }

    @Override
    public void cut() {
        if (!this.checkEditAllowed()) {
            return;
        }
        EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
        SelectionRange selection = ((SelectionCapable)((Object)this.codeArea)).getSelection();
        if (!selection.isEmpty()) {
            this.copy();
            if (editMode == EditMode.EXPANDING) {
                this.deleteSelection();
                this.codeArea.notifyDataChanged();
            }
        }
    }

    @Override
    public void paste() {
        block17: {
            if (!this.checkEditAllowed()) {
                return;
            }
            try {
                if (!(this.clipboard.isDataFlavorAvailable(this.binedDataFlavor) || this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor) || this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) || this.clipboard.isDataFlavorAvailable(DataFlavor.getTextPlainUnicodeFlavor()))) {
                    return;
                }
            }
            catch (IllegalStateException ex4) {
                return;
            }
            try {
                if (this.clipboard.isDataFlavorAvailable(this.binedDataFlavor)) {
                    try {
                        Object clipboardData = this.clipboard.getData(this.binedDataFlavor);
                        if (clipboardData instanceof BinaryData) {
                            this.pasteBinaryData((BinaryData)clipboardData);
                        }
                        break block17;
                    }
                    catch (UnsupportedFlavorException | IOException ex5) {
                        Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex5);
                    }
                    break block17;
                }
                if (this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor)) {
                    try {
                        Object clipboardData = this.clipboard.getData(this.binaryDataFlavor);
                        if (clipboardData instanceof InputStream) {
                            ByteArrayEditableData pastedData = new ByteArrayEditableData();
                            pastedData.insert(0L, (InputStream)clipboardData, -1L);
                            this.pasteBinaryData(pastedData);
                        }
                        break block17;
                    }
                    catch (UnsupportedFlavorException | IOException ex6) {
                        Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex6);
                    }
                    break block17;
                }
                if (!this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) break block17;
                try {
                    Object clipboardData = this.clipboard.getData(DataFlavor.stringFlavor);
                    if (clipboardData instanceof String) {
                        byte[] bytes = ((String)clipboardData).getBytes(((CharsetCapable)((Object)this.codeArea)).getCharset());
                        ByteArrayData pastedData = new ByteArrayData(bytes);
                        this.pasteBinaryData(pastedData);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex7) {
                    Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex7);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void pasteBinaryData(BinaryData pastedData) {
        long clipDataSize;
        BinaryData data = this.codeArea.getContentData();
        EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
        EditOperation editOperation = ((EditModeCapable)((Object)this.codeArea)).getActiveOperation();
        if (this.codeArea.hasSelection()) {
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
        }
        DefaultCodeAreaCaret caret = (DefaultCodeAreaCaret)((CaretCapable)((Object)this.codeArea)).getCodeAreaCaret();
        long dataPosition = caret.getDataPosition();
        long toReplace = clipDataSize = pastedData.getDataSize();
        if (editMode == EditMode.INPLACE) {
            if (dataPosition + toReplace > this.codeArea.getDataSize()) {
                toReplace = this.codeArea.getDataSize() - dataPosition;
            }
            ((EditableBinaryData)data).replace(dataPosition, pastedData, 0L, toReplace);
        } else {
            if (editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE) {
                if (dataPosition + toReplace > this.codeArea.getDataSize()) {
                    toReplace = this.codeArea.getDataSize() - dataPosition;
                }
                ((EditableBinaryData)data).remove(dataPosition, toReplace);
            }
            ((EditableBinaryData)data).insert(dataPosition, pastedData);
            caret.setCaretPosition(caret.getDataPosition() + clipDataSize);
            this.updateSelection(SelectingMode.NONE, caret.getCaretPosition());
        }
        caret.setCodeOffset(0);
        ((CaretCapable)((Object)this.codeArea)).setActiveCaretPosition(caret.getCaretPosition());
        this.sequenceBreak();
        this.codeArea.notifyDataChanged();
        this.revealCursor();
        this.clearSelection();
    }

    public void pasteFromCode() {
        block11: {
            if (!this.checkEditAllowed()) {
                return;
            }
            BinaryData data = this.codeArea.getContentData();
            EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
            EditOperation editOperation = ((EditModeCapable)((Object)this.codeArea)).getActiveOperation();
            try {
                if (!this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor) && !this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    return;
                }
            }
            catch (IllegalStateException ex4) {
                return;
            }
            try {
                if (this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor)) {
                    this.paste();
                    break block11;
                }
                if (!this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) break block11;
                if (this.codeArea.hasSelection()) {
                    this.deleteSelection();
                    this.codeArea.notifyDataChanged();
                }
                try {
                    Object insertedData = this.clipboard.getData(DataFlavor.stringFlavor);
                    if (insertedData instanceof String) {
                        CodeType codeType = this.getCodeType();
                        ByteArrayEditableData pastedData = new ByteArrayEditableData();
                        CodeAreaUtils.insertHexStringIntoData((String)insertedData, pastedData, codeType);
                        this.pasteBinaryData(pastedData);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex5) {
                    Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex5);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canPaste() {
        return this.canPaste;
    }

    @Nonnull
    public EnterKeyHandlingMode getEnterKeyHandlingMode() {
        return this.enterKeyHandlingMode;
    }

    public void setEnterKeyHandlingMode(EnterKeyHandlingMode enterKeyHandlingMode) {
        this.enterKeyHandlingMode = enterKeyHandlingMode;
    }

    @Nonnull
    public TabKeyHandlingMode getTabKeyHandlingMode() {
        return this.tabKeyHandlingMode;
    }

    public void setTabKeyHandlingMode(TabKeyHandlingMode tabKeyHandlingMode) {
        this.tabKeyHandlingMode = tabKeyHandlingMode;
    }

    @Override
    public void selectAll() {
        long dataSize = this.codeArea.getDataSize();
        if (dataSize > 0L) {
            ((SelectionCapable)((Object)this.codeArea)).setSelection(0L, dataSize);
        }
    }

    @Override
    public void clearSelection() {
        long dataPosition = ((CaretCapable)((Object)this.codeArea)).getActiveCaretPosition().getDataPosition();
        ((SelectionCapable)((Object)this.codeArea)).setSelection(dataPosition, dataPosition);
    }

    public void updateSelection(SelectingMode selectingMode, CodeAreaCaretPosition caretPosition) {
        long dataPosition = ((CaretCapable)((Object)this.codeArea)).getDataPosition();
        SelectionRange selection = ((SelectionCapable)((Object)this.codeArea)).getSelection();
        if (selectingMode == SelectingMode.SELECTING) {
            ((SelectionCapable)((Object)this.codeArea)).setSelection(selection.getStart(), dataPosition);
        } else {
            ((SelectionCapable)((Object)this.codeArea)).setSelection(dataPosition, dataPosition);
        }
    }

    private void updateCanPaste() {
        this.canPaste = CodeAreaSwingUtils.canPaste(this.clipboard, this.binaryDataFlavor);
    }

    @Override
    public void moveCaret(int positionX, int positionY, SelectingMode selecting) {
        CodeAreaCaretPosition caretPosition = ((CaretCapable)((Object)this.codeArea)).mousePositionToClosestCaretPosition(positionX, positionY, CaretOverlapMode.PARTIAL_OVERLAP);
        ((CaretCapable)((Object)this.codeArea)).setActiveCaretPosition(caretPosition);
        this.updateSelection(selecting, caretPosition);
        this.sequenceBreak();
        this.codeArea.repaint();
    }

    public void move(SelectingMode selectingMode, MovementDirection direction) {
        CodeAreaCaretPosition movePosition;
        CodeAreaCaretPosition caretPosition = ((CaretCapable)((Object)this.codeArea)).getActiveCaretPosition();
        if (!caretPosition.equals(movePosition = ((CaretCapable)((Object)this.codeArea)).computeMovePosition(caretPosition, direction))) {
            ((CaretCapable)((Object)this.codeArea)).setActiveCaretPosition(movePosition);
            this.updateSelection(selectingMode, movePosition);
        } else if (selectingMode == SelectingMode.NONE) {
            this.clearSelection();
        }
    }

    public void scroll(ScrollingDirection direction) {
        CodeAreaScrollPosition scrollPosition;
        CodeAreaScrollPosition sourcePosition = ((ScrollingCapable)((Object)this.codeArea)).getScrollPosition();
        if (!sourcePosition.equals(scrollPosition = ((ScrollingCapable)((Object)this.codeArea)).computeScrolling(sourcePosition, direction))) {
            ((ScrollingCapable)((Object)this.codeArea)).setScrollPosition(scrollPosition);
            this.codeArea.resetPainter();
        }
    }

    @Override
    public void wheelScroll(int scrollSize, ScrollBarOrientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                if (scrollSize > 0) {
                    this.scroll(ScrollingDirection.LEFT);
                    break;
                }
                if (scrollSize >= 0) break;
                this.scroll(ScrollingDirection.RIGHT);
                break;
            }
            case VERTICAL: {
                if (scrollSize > 0) {
                    this.scroll(ScrollingDirection.DOWN);
                    break;
                }
                if (scrollSize >= 0) break;
                this.scroll(ScrollingDirection.UP);
            }
        }
    }

    public boolean changeEditOperation() {
        EditMode editMode = ((EditModeCapable)((Object)this.codeArea)).getEditMode();
        if (editMode == EditMode.EXPANDING || editMode == EditMode.CAPPED) {
            EditOperation editOperation = ((EditModeCapable)((Object)this.codeArea)).getEditOperation();
            switch (editOperation) {
                case INSERT: {
                    ((EditModeCapable)((Object)this.codeArea)).setEditOperation(EditOperation.OVERWRITE);
                    break;
                }
                case OVERWRITE: {
                    ((EditModeCapable)((Object)this.codeArea)).setEditOperation(EditOperation.INSERT);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isValidChar(char value) {
        return ((CharsetCapable)((Object)this.codeArea)).getCharset().canEncode();
    }

    @Nonnull
    public byte[] charToBytes(char value) {
        ByteBuffer buffer = ((CharsetCapable)((Object)this.codeArea)).getCharset().encode(Character.toString(value));
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    @Nonnull
    protected CodeType getCodeType() {
        if (this.codeTypeSupported) {
            return ((CodeTypeCapable)((Object)this.codeArea)).getCodeType();
        }
        return CodeType.HEXADECIMAL;
    }

    protected void revealCursor() {
        ((ScrollingCapable)((Object)this.codeArea)).revealCursor();
        this.codeArea.repaint();
    }

    @Override
    public boolean checkEditAllowed() {
        return this.codeArea.isEditable();
    }

    @Nonnull
    protected static SelectingMode isSelectingMode(KeyEvent keyEvent) {
        return (keyEvent.getModifiersEx() & 0x40) > 0 ? SelectingMode.SELECTING : SelectingMode.NONE;
    }
}

