/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context.cache;

import com.apicatalog.jsonld.context.cache.Cache;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LruCache<K, V>
implements Cache<K, V> {
    private final Map<K, V> cache;

    public LruCache(final int maxCapacity) {
        this.cache = new LinkedHashMap<K, V>((int)((double)maxCapacity / 0.75 + 1.0), 0.75f, true){
            private static final long serialVersionUID = 4822962879473741809L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxCapacity;
            }
        };
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public long size() {
        return this.cache.size();
    }
}

