/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;

public class MultiConcatOp<T>
extends AbstractMulti<T> {
    private final Flow.Publisher<? extends T>[] publishers;
    private final boolean postponeFailurePropagation;

    @SafeVarargs
    public MultiConcatOp(boolean postponeFailurePropagation, Flow.Publisher<? extends T> ... publishers) {
        this.publishers = ParameterValidation.doesNotContainNull(publishers, "publishers");
        this.postponeFailurePropagation = postponeFailurePropagation;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        if (actual == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        if (this.publishers.length == 0) {
            Subscriptions.complete(actual);
            return;
        }
        if (this.publishers.length == 1) {
            this.publishers[0].subscribe(Infrastructure.onMultiSubscription(this.publishers[0], actual));
            return;
        }
        if (this.postponeFailurePropagation) {
            Multi.createFrom().items(this.publishers).onItem().transformToMulti(publisher -> publisher).collectFailures().concatenate().subscribe().withSubscriber(actual);
        } else {
            Multi.createFrom().items(this.publishers).onItem().transformToMulti(publisher -> publisher).concatenate().subscribe().withSubscriber(actual);
        }
    }
}

