/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.ClassFileElement;
import io.github.dmlloyd.classfile.FieldBuilder;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.creator.FieldCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.ModifiableCreatorImpl;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayDeque;
import java.util.ArrayList;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class FieldCreatorImpl
extends ModifiableCreatorImpl
implements FieldCreator {
    final ClassDesc owner;
    final String name;
    final TypeCreatorImpl tc;
    GenericType genericType = GenericType.of(ConstantDescs.CD_int);
    private FieldDesc desc;

    public FieldCreatorImpl(ClassDesc owner, String name, TypeCreatorImpl tc) {
        super(tc.gizmo);
        this.owner = owner;
        this.name = name;
        this.tc = tc;
    }

    @Override
    public FieldDesc desc() {
        FieldDesc desc = this.desc;
        if (desc == null) {
            desc = this.desc = FieldDesc.of(this.owner, this.name, this.type());
        }
        return desc;
    }

    @Override
    public void setType(GenericType genericType) {
        Assert.checkNotNullParam((String)"genericType", (Object)genericType);
        if (genericType.desc().equals(ConstantDescs.CD_void)) {
            throw new IllegalArgumentException("Fields cannot have void type");
        }
        this.genericType = genericType;
        this.desc = null;
    }

    @Override
    public void setType(ClassDesc type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        if (type.equals(ConstantDescs.CD_void)) {
            throw new IllegalArgumentException("Fields cannot have void type");
        }
        this.genericType = GenericType.of(type);
        this.desc = null;
    }

    @Override
    public ClassDesc owner() {
        return this.owner;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public GenericType genericType() {
        return this.genericType;
    }

    @Override
    public ClassDesc type() {
        return this.genericType.desc();
    }

    @Override
    public ElementType annotationTargetType() {
        return ElementType.FIELD;
    }

    void addTypeAnnotations(FieldBuilder fb) {
        ArrayList<TypeAnnotation> visible = new ArrayList<TypeAnnotation>();
        ArrayList<TypeAnnotation> invisible = new ArrayList<TypeAnnotation>();
        Util.computeAnnotations(this.genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofField(), visible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        Util.computeAnnotations(this.genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofField(), invisible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        if (!visible.isEmpty()) {
            fb.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(visible));
        }
        if (!invisible.isEmpty()) {
            fb.with((ClassFileElement)RuntimeInvisibleTypeAnnotationsAttribute.of(invisible));
        }
    }
}

