/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.AcrCondition;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class AcrConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "acr-condition";
    public static final String ACR_PROPERTY = "acr-property";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new AcrCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition is satisfied when configured acr value is requested";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty(ACR_PROPERTY, "ACR", "ACR to be requested to satisfy the condition", "String", null);
        configProperties.add(property);
    }
}

