/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import org.keycloak.common.util.IoUtils;
import org.keycloak.config.OptionCategory;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractNonServerCommand;
import org.keycloak.quarkus.runtime.cli.command.BootstrapAdmin;
import org.keycloak.quarkus.runtime.integration.jaxrs.QuarkusKeycloakApplication;
import org.keycloak.services.resources.KeycloakApplication;
import picocli.CommandLine;

@CommandLine.Command(name="user", header={"Add an admin user with a password"}, description={"%nAdd an admin user with a password"})
public class BootstrapAdminUser
extends AbstractNonServerCommand {
    public static final String NAME = "user";
    public static final String HEADER = "Add an admin user with a password";
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    UsernameOptions usernameOptions;
    @CommandLine.Option(paramLabel="PASSWORD", names={"--password:env"}, description={"Environment variable name for the admin user password"})
    String passwordEnv;
    String password;
    String username;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void doBeforeRun() {
        BootstrapAdmin bootstrap = (BootstrapAdmin)this.spec.commandLine().getParent().getCommand();
        if (this.usernameOptions != null) {
            this.username = this.usernameOptions.usernameEnv != null ? this.getFromEnv(this.usernameOptions.usernameEnv) : this.usernameOptions.username;
        } else if (!bootstrap.noPrompt) {
            this.username = IoUtils.readLineFromConsole((String)"username", (String)"temp-admin");
        }
        if (this.passwordEnv == null) {
            if (bootstrap.noPrompt) {
                throw new PropertyException("No password provided");
            }
            this.password = IoUtils.readPasswordFromConsole((String)"password");
            String confirmPassword = IoUtils.readPasswordFromConsole((String)"password again");
            if (!this.password.equals(confirmPassword)) {
                throw new PropertyException("Passwords do not match");
            }
            if (this.password.isBlank()) {
                throw new PropertyException("Password must not be blank");
            }
        } else {
            this.password = this.getFromEnv(this.passwordEnv);
        }
    }

    private String getFromEnv(String envVar) {
        String result = System.getenv(envVar);
        if (result == null) {
            throw new PropertyException(String.format("Environment variable %s not found", envVar));
        }
        return result;
    }

    @Override
    public void onStart(QuarkusKeycloakApplication application) {
        KeycloakSessionFactory sessionFactory = KeycloakApplication.getSessionFactory();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, session -> application.createTemporaryMasterRealmAdminUser(this.username, this.password, session));
    }

    @Override
    public boolean isHiddenCategory(OptionCategory category) {
        return category == OptionCategory.BOOTSTRAP_ADMIN || super.isHiddenCategory(category);
    }

    static class UsernameOptions {
        @CommandLine.Option(paramLabel="username", names={"--username"}, description={"Username of admin user, defaults to temp-admin"})
        String username;
        @CommandLine.Option(paramLabel="USERNAME", names={"--username:env"}, description={"Environment variable name for the admin username"})
        String usernameEnv;

        UsernameOptions() {
        }
    }
}

