/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class FlatTaskPaneUI
extends BasicTaskPaneUI {
    private Color background;

    public static ComponentUI createUI(JComponent c) {
        return new FlatTaskPaneUI();
    }

    protected void installDefaults() {
        if (this.group.getContentPane() instanceof JComponent) {
            JComponent content = (JComponent)this.group.getContentPane();
            Border contentBorder = content.getBorder();
            if (contentBorder instanceof CompoundBorder && ((CompoundBorder)contentBorder).getOutsideBorder() instanceof BasicTaskPaneUI.ContentPaneBorder && ((CompoundBorder)contentBorder).getInsideBorder() instanceof EmptyBorder) {
                content.setBorder(null);
            }
            this.background = UIManager.getColor("TaskPane.background");
            Color bg = content.getBackground();
            if (bg == null || bg instanceof UIResource) {
                content.setBackground(new Color(this.background.getRGB(), true));
            }
        }
        this.roundHeight = FlatUIUtils.getUIInt((String)"TaskPane.roundHeight", (int)UIManager.getInt("Component.arc"));
        super.installDefaults();
    }

    public void uninstallUI(JComponent c) {
        if (this.group.getContentPane() instanceof JComponent) {
            JComponent content = (JComponent)this.group.getContentPane();
            if (content.getBorder() instanceof FlatContentPaneBorder) {
                content.setBorder(null);
            }
            if (this.background.equals(content.getBackground())) {
                content.setBackground(this.background);
            }
            this.background = null;
        }
        super.uninstallUI(c);
    }

    protected int getTitleHeight(Component c) {
        return Math.max(super.getTitleHeight(c), UIScale.scale((int)this.titleHeight));
    }

    protected int getRoundHeight() {
        return UIScale.scale((int)this.roundHeight);
    }

    protected Border createPaneBorder() {
        return new FlatPaneBorder();
    }

    protected Border createContentPaneBorder() {
        return new FlatContentPaneBorder(UIManager.getColor("TaskPane.borderColor"), UIManager.getInsets("TaskPane.contentInsets"));
    }

    private class FlatPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        private FlatPaneBorder() {
            super((BasicTaskPaneUI)FlatTaskPaneUI.this);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints((Graphics)g);
            super.paintBorder(c, g, x, y, width, height);
            FlatUIUtils.resetRenderingHints((Graphics)g, (Object[])oldRenderingHints);
        }

        protected void paintTitleBackground(JXTaskPane group, Graphics g) {
            int width = group.getWidth();
            int height = FlatTaskPaneUI.this.getTitleHeight((Component)group);
            float arc = UIScale.scale((float)FlatTaskPaneUI.this.roundHeight);
            float lineWidth = UIScale.scale((float)1.0f);
            g.setColor(group.isSpecial() ? this.specialTitleBackground : this.titleBackgroundGradientStart);
            ((Graphics2D)g).fill(FlatUIUtils.createRoundRectanglePath((float)lineWidth, (float)lineWidth, (float)((float)width - lineWidth * 2.0f), (float)((float)height - lineWidth * 2.0f), (float)(arc - lineWidth), (float)(arc - lineWidth), (float)0.0f, (float)0.0f));
            if (this.borderColor != null) {
                g.setColor(this.borderColor);
                ((Graphics2D)g).fill(FlatUIUtils.createRoundRectangle((float)0.0f, (float)0.0f, (float)width, (float)height, (float)lineWidth, (float)arc, (float)arc, (float)0.0f, (float)0.0f));
            }
        }

        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.getPaintColor(group));
            this.paintChevronControls(group, g, x, y, width, height);
        }

        protected void paintChevronControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g;
            float cw = UIScale.scale((float)7.0f);
            float ch = UIScale.scale((float)3.5f);
            int direction = group.isCollapsed() ? 5 : 1;
            Shape arrowShape = FlatUIUtils.createArrowShape((int)direction, (boolean)true, (float)cw, (float)ch);
            x = group.getComponentOrientation().isLeftToRight() ? group.getWidth() - width - y : y;
            int cx = (int)((float)(x + width / 2) - cw / 2.0f);
            int cy = (int)((float)(y + height / 2) - ch);
            float offset = ch + UIScale.scale((float)1.0f);
            g2.setStroke(new BasicStroke(UIScale.scale((float)1.0f)));
            g2.translate(cx, cy);
            FlatUIUtils.drawShapePure((Graphics2D)g2, (Shape)arrowShape);
            g2.translate(0.0, offset);
            FlatUIUtils.drawShapePure((Graphics2D)g2, (Shape)arrowShape);
            g2.translate((double)(-cx), -((float)cy + offset));
        }

        protected void paintTitle(JXTaskPane group, Graphics g, Color textColor, int x, int y, int width, int height) {
            int titleX = UIScale.scale((int)3);
            int titleWidth = group.getWidth() - FlatTaskPaneUI.this.getTitleHeight((Component)group) - titleX;
            if (!group.getComponentOrientation().isLeftToRight()) {
                titleX = group.getWidth() - titleX - titleWidth;
            }
            super.paintTitle(group, g, textColor, titleX, y, titleWidth, height);
        }

        protected void paintFocus(Graphics g, Color paintColor, int x, int y, int width, int height) {
            int sx = UIScale.scale((int)x);
            int sy = UIScale.scale((int)y);
            int swidth = width - (sx - x) * 2;
            int sheight = height - (sy - y) * 2;
            super.paintFocus(g, paintColor, sx, sy, swidth, sheight);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }
    }

    private static class FlatContentPaneBorder
    extends EmptyBorder {
        Color color;

        FlatContentPaneBorder(Color color, Insets insets) {
            super(insets);
            this.color = color;
            ++this.left;
            ++this.right;
            ++this.bottom;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.color == null) {
                return;
            }
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints((Graphics)g);
            g.setColor(this.color);
            float lineWidth = UIScale.scale((float)1.0f);
            Path2D.Float path = new Path2D.Float(0);
            path.append(new Rectangle2D.Float(x, y, width, height), false);
            path.append(new Rectangle2D.Float((float)x + lineWidth, y, (float)width - lineWidth * 2.0f, (float)height - lineWidth), false);
            ((Graphics2D)g).fill(path);
            FlatUIUtils.resetRenderingHints((Graphics)g, (Object[])oldRenderingHints);
        }

        @Override
        public Insets getBorderInsets() {
            return new Insets(UIScale.scale((int)this.top), UIScale.scale((int)this.left), UIScale.scale((int)this.bottom), UIScale.scale((int)this.right));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = UIScale.scale((int)this.left);
            insets.top = UIScale.scale((int)this.top);
            insets.right = UIScale.scale((int)this.right);
            insets.bottom = UIScale.scale((int)this.bottom);
            return insets;
        }
    }
}

