/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.SdkBaseException;
import com.amazonaws.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;

public final class HttpException
extends SdkBaseException {
    private final int statusCode;

    HttpException(String message, HttpResponse response) {
        super(String.format("%s: %d %s.%n%s", message, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), HttpException.trySlurpContent(response)));
        this.statusCode = response.getStatusLine().getStatusCode();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private static String trySlurpContent(HttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent());
        }
        catch (IOException e) {
            return "";
        }
    }
}

